/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.prefab.impl;

import com.wavemaker.runtime.prefab.config.PrefabsConfig;
import com.wavemaker.runtime.prefab.core.PrefabFactory;
import com.wavemaker.runtime.prefab.core.PrefabInstaller;
import com.wavemaker.runtime.prefab.core.PrefabLoader;
import com.wavemaker.runtime.prefab.core.PrefabManager;
import com.wavemaker.runtime.prefab.event.PrefabEvent;
import com.wavemaker.runtime.prefab.event.PrefabsLoadedEvent;
import com.wavemaker.runtime.prefab.util.PrefabConstants;
import com.wavemaker.runtime.prefab.util.PrefabUtils;
import com.wavemaker.runtime.prefab.util.Utils;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.ContextStoppedEvent;
import org.springframework.stereotype.Service;

@Service
public class PrefabLoaderImpl
implements PrefabLoader,
ApplicationListener<ApplicationEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrefabLoaderImpl.class);
    @Autowired
    private PrefabUtils prefabUtils;
    @Autowired
    private PrefabsConfig prefabsConfig;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private PrefabManager prefabManager;
    @Autowired
    private PrefabFactory prefabFactory;
    @Autowired
    private PrefabInstaller prefabInstaller;

    public PrefabManager getPrefabManager() {
        return this.prefabManager;
    }

    public PrefabFactory getPrefabFactory() {
        return this.prefabFactory;
    }

    @Override
    public synchronized void loadPrefabs() {
        LOGGER.info("Context refreshed, (re)loading prefabs");
        this.prefabInstaller.uninstallPrefabs();
        for (File prefabDir : this.readPrefabDirs()) {
            try {
                this.loadPrefab(prefabDir);
            }
            catch (Exception e) {
                LOGGER.warn("Prefab: [{}] could not be loaded", (Object)prefabDir.getName(), (Object)e);
            }
        }
        if (!this.prefabsConfig.isLazyInitPrefabs()) {
            this.prefabInstaller.installPrefabs();
        }
        this.publishEvent(new PrefabsLoadedEvent(this.context));
    }

    @Override
    public synchronized void loadPrefab(File prefabDir) throws Exception {
        if (Utils.isReadableDirectory(prefabDir)) {
            this.prefabManager.addPrefab(this.prefabFactory.newPrefab(prefabDir));
            LOGGER.info("Loaded prefab [{}]", (Object)prefabDir.getName());
        } else {
            LOGGER.warn("Cannot load prefab [{}], Reason: Access Denied!", (Object)prefabDir.getName());
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            if (event.getSource() == this.context) {
                this.loadPrefabs();
            }
        } else if ((event instanceof ContextClosedEvent || event instanceof ContextStoppedEvent) && event.getSource() == this.context) {
            this.prefabInstaller.uninstallPrefabs();
        }
    }

    protected File[] readPrefabDirs() {
        File[] prefabs;
        try {
            File prefabsDirectory = this.prefabUtils.getDirectory(this.prefabsConfig.getPrefabsHomeDir());
            prefabs = this.prefabUtils.listPrefabDirectories(prefabsDirectory);
        }
        catch (IOException e) {
            LOGGER.warn("Prefabs feature disabled. Reason: {}", (Object)e.getMessage());
            prefabs = PrefabConstants.ZERO_FILES;
        }
        return prefabs;
    }

    private void publishEvent(PrefabEvent event) {
        if (this.context != null) {
            this.context.publishEvent((ApplicationEvent)event);
        }
    }
}

