/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.prefab.impl;

import com.wavemaker.runtime.prefab.core.Prefab;
import com.wavemaker.runtime.prefab.core.PrefabInstaller;
import com.wavemaker.runtime.prefab.core.PrefabManager;
import com.wavemaker.runtime.prefab.util.Utils;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrefabManagerImpl
implements PrefabManager {
    private static final Map<String, Prefab> prefabs = Utils.newConcurrentMap();
    @Autowired
    private PrefabInstaller prefabInstaller;

    @Override
    public synchronized void addPrefab(Prefab prefab) {
        this.deletePrefab(prefab.getName());
        prefabs.put(prefab.getName(), prefab);
    }

    @Override
    public synchronized void deletePrefab(String prefabName) {
        if (StringUtils.isEmpty((CharSequence)prefabName)) {
            return;
        }
        Prefab existingPrefab = this.getPrefab(prefabName);
        if (existingPrefab != null) {
            prefabs.remove(existingPrefab.getName().toLowerCase());
        }
    }

    @Override
    public synchronized void deleteAllPrefabs() {
        prefabs.clear();
    }

    @Override
    public Collection<Prefab> getPrefabs() {
        return CollectionUtils.unmodifiableCollection(prefabs.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Prefab getPrefab(String prefabName) {
        Validate.notNull((Object)prefabName, (String)"PrefabManagerImpl: Prefab name should not be null", (Object[])new Object[0]);
        Prefab prefab = prefabs.get(prefabName);
        if (prefab == null) {
            return null;
        }
        if (!prefab.isInstalled()) {
            Prefab prefab2 = prefab;
            synchronized (prefab2) {
                if (!prefab.isInstalled()) {
                    this.prefabInstaller.installPrefab(prefab);
                }
            }
        }
        return prefab;
    }
}

