/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.prefab.impl;

import com.wavemaker.runtime.prefab.core.PrefabRegistry;
import com.wavemaker.runtime.prefab.util.Utils;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="prefabRegistry")
public class PrefabRegistryImpl
implements PrefabRegistry {
    private final Map<String, ConfigurableApplicationContext> prefabRegistryMap = Utils.newConcurrentMap();

    @Override
    public synchronized void addPrefabContext(String prefabName, ConfigurableApplicationContext context) {
        this.prefabRegistryMap.put(prefabName, context);
    }

    @Override
    public synchronized void deletePrefabContext(String prefabName) {
        this.prefabRegistryMap.remove(prefabName);
    }

    @Override
    public ConfigurableApplicationContext getPrefabContext(String prefabName) {
        return this.prefabRegistryMap.get(prefabName);
    }

    @Override
    public Set<String> getPrefabs() {
        return Collections.unmodifiableSet(this.prefabRegistryMap.keySet());
    }

    @Override
    public void deletePrefabContexts() {
        this.prefabRegistryMap.clear();
    }
}

