/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.prefab.util;

import com.wavemaker.runtime.prefab.config.PrefabsConfig;
import com.wavemaker.runtime.prefab.util.PrefabConstants;
import com.wavemaker.runtime.prefab.util.Utils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.util.WebUtils;

@Service
public class PrefabUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrefabUtils.class);
    @Autowired
    private ServletContext servletContext;
    @Autowired
    private PrefabsConfig prefabsConfig;

    public File getDirectory(String path) throws IOException {
        Objects.requireNonNull(path, "Path cannot be null");
        String realPath = path.trim();
        realPath = WebUtils.getRealPath((ServletContext)this.servletContext, (String)realPath);
        File directory = new File(realPath);
        if (!directory.exists()) {
            throw new FileNotFoundException("File not exist in ServletContext resource with given path: [" + path + "]");
        }
        if (Utils.isNotReadableDirectory(directory)) {
            throw new IOException("Given path [" + path + "] is not a directory (or) doesn't have read permissions.");
        }
        return directory;
    }

    public File[] readJarFilesForPrefab(File prefabDir) {
        File libDirectory = this.getPrefabLibDirectory(prefabDir);
        File[] jars = null;
        if (libDirectory.exists()) {
            jars = libDirectory.listFiles(Utils.getJarFilter());
        }
        return jars == null ? PrefabConstants.ZERO_FILES : jars;
    }

    public File getPrefabLibDirectory(File prefabDirectory) {
        return new File(prefabDirectory, this.prefabsConfig.getPrefabLibDir());
    }

    public File getPrefabConfigDirectory(File prefabDirectory) {
        return new File(prefabDirectory, this.prefabsConfig.getPrefabConfigDir());
    }

    public File getPrefabBuildDirectory(File prefabDirectory) {
        return new File(prefabDirectory, this.prefabsConfig.getPrefabBuildDir());
    }

    public boolean isDirContainsConfig(File directory) {
        File prefabConfigDirectory = new File(directory, this.prefabsConfig.getPrefabConfigDir());
        if (prefabConfigDirectory.exists() && prefabConfigDirectory.isDirectory()) {
            File[] files = prefabConfigDirectory.listFiles();
            return files.length > 0;
        }
        return false;
    }

    public boolean isDirContainsLib(File directory) {
        File prefabLibDirectory = new File(directory, this.prefabsConfig.getPrefabLibDir());
        if (prefabLibDirectory.exists() && prefabLibDirectory.isDirectory()) {
            File[] files = prefabLibDirectory.listFiles();
            return files.length > 0;
        }
        return false;
    }

    public boolean isPrefabDirectory(File pathName) {
        return this.isDirContainsConfig(pathName) || this.isDirContainsLib(pathName);
    }

    public FileFilter getPrefabDirectoryFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return Utils.isReadableDirectory(pathname) && PrefabUtils.this.isPrefabDirectory(pathname);
            }
        };
    }

    public File[] listPrefabDirectories(File directory) {
        File[] dirs = directory.listFiles(this.getPrefabDirectoryFilter());
        return dirs == null ? PrefabConstants.ZERO_FILES : dirs;
    }

    public static String sanitizePrefabName(String prefabName) {
        return prefabName.trim().replaceAll("\\s+", "_");
    }
}

