/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.prefab.util;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Utils {
    public static String getStringSystemProperty(String key, String defaultValue) {
        String value = defaultValue;
        try {
            String _value = System.getProperty(key);
            value = _value == null ? defaultValue : _value.trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public static boolean isReadableJarFile(File file) {
        return file != null && file.isFile() && file.getName().endsWith(".jar") && file.canRead();
    }

    public static FileFilter getJarFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return Utils.isReadableJarFile(file);
            }
        };
    }

    public static boolean isReadableDirectory(File directory) {
        return directory != null && directory.isDirectory() && directory.canRead();
    }

    public static boolean isNotReadableDirectory(File directory) {
        return !Utils.isReadableDirectory(directory);
    }

    public static boolean isGivenDirectoryAvaliable(File homeDir, String requiredDirName) {
        File[] files;
        for (File file : files = homeDir.listFiles()) {
            if (!file.isDirectory() || !file.getName().equals(requiredDirName)) continue;
            return true;
        }
        return false;
    }

    public static URL[] convertToURLS(File configDir, File[] files) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : files) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        try {
            urls.add(configDir.toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return urls.toArray(new URL[0]);
    }

    public static <K, V> Map<K, V> newConcurrentMap() {
        return new ConcurrentHashMap();
    }
}

