/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.prefab.web;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.runtime.prefab.context.PrefabThreadLocalContextManager;
import com.wavemaker.runtime.prefab.core.Prefab;
import com.wavemaker.runtime.prefab.core.PrefabManager;
import com.wavemaker.runtime.prefab.core.PrefabRegistry;
import com.wavemaker.runtime.prefab.web.PrefabAwareHttpRequestWrapper;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.WebUtils;

public class PrefabControllerServlet
extends DispatcherServlet {
    private final UrlPathHelper urlPathHelper = new UrlPathHelper();
    @Autowired
    private PrefabThreadLocalContextManager prefabThreadLocalContextManager;
    @Autowired
    private PrefabRegistry prefabRegistry;
    @Autowired
    private PrefabManager prefabManager;
    private static final Logger logger = LoggerFactory.getLogger(PrefabControllerServlet.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        SpringBeanAutowiringSupport.processInjectionBasedOnServletContext((Object)((Object)this), (ServletContext)config.getServletContext());
    }

    public PrefabControllerServlet() {
        this.setDetectAllHandlerMappings(false);
        this.setDetectAllHandlerAdapters(false);
        this.setDetectAllHandlerExceptionResolvers(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDispatch(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ApplicationContext context = null;
        ClassLoader previous = null;
        try {
            context = this.lookupContext(request);
            this.prefabThreadLocalContextManager.setContext(context);
            previous = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(context.getClassLoader());
            PrefabAwareHttpRequestWrapper updatedRequest = new PrefabAwareHttpRequestWrapper(request, context.getId());
            super.doDispatch((HttpServletRequest)updatedRequest, response);
            if (context != null) {
                Thread.currentThread().setContextClassLoader(previous);
            }
            this.prefabThreadLocalContextManager.clearContext();
        }
        catch (Throwable throwable) {
            if (context != null) {
                Thread.currentThread().setContextClassLoader(previous);
            }
            this.prefabThreadLocalContextManager.clearContext();
            throw throwable;
        }
    }

    private String getServletPathWithPrefabName(String servletPath, String prefabName) {
        servletPath = servletPath.endsWith("/") ? servletPath.substring(0, servletPath.length() - 1) : servletPath;
        prefabName = prefabName.startsWith("/") ? servletPath.substring(1) : prefabName;
        return servletPath + "/" + prefabName;
    }

    protected HandlerExecutionChain getHandler(HttpServletRequest request) throws Exception {
        ApplicationContext context = this.lookupContext(request);
        Map handlerMappingMap = context.getBeansOfType(HandlerMapping.class);
        for (HandlerMapping hm : handlerMappingMap.values()) {
            HandlerExecutionChain handler;
            if (logger.isTraceEnabled()) {
                logger.trace("Testing handler map [{}] in DispatcherServlet with name '{}'", (Object)hm, (Object)this.getServletName());
            }
            if ((handler = hm.getHandler(request)) == null) continue;
            return handler;
        }
        return null;
    }

    private String extractPrefabName(String lookupPath) {
        if (lookupPath != null && !lookupPath.isEmpty() && !lookupPath.equals("/")) {
            int startIndex = lookupPath.startsWith("/") ? 1 : 0;
            int endIndex = lookupPath.indexOf(47, startIndex);
            if (endIndex != -1) {
                return lookupPath.substring(startIndex, lookupPath.indexOf(47, startIndex));
            }
            return lookupPath.substring(startIndex);
        }
        return null;
    }

    private ApplicationContext lookupContext(HttpServletRequest request) {
        ApplicationContext prefabContext = (ApplicationContext)request.getAttribute("wm.request.prefabContext");
        if (prefabContext == null) {
            String urlPath = this.urlPathHelper.getLookupPathForRequest(request);
            String prefabName = this.extractPrefabName(urlPath);
            if (prefabName == null) {
                throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.invalid.url.for.accessing.prefab"), new Object[]{urlPath});
            }
            Prefab prefab = this.prefabManager.getPrefab(prefabName);
            if (prefab == null) {
                throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.prefab.not.found"), new Object[]{prefabName});
            }
            prefabContext = this.prefabRegistry.getPrefabContext(prefab.getName());
            request.setAttribute("javax.servlet.include.servlet_path", (Object)this.getServletPathWithPrefabName(request.getServletPath(), prefabContext.getId()));
            request.setAttribute("wm.request.prefabContext", (Object)prefabContext);
        }
        return prefabContext;
    }

    protected HandlerAdapter getHandlerAdapter(Object handler) throws ServletException {
        Map handlerAdapterMap = this.prefabThreadLocalContextManager.getContext().getBeansOfType(HandlerAdapter.class);
        for (HandlerAdapter ha : handlerAdapterMap.values()) {
            if (logger.isTraceEnabled()) {
                logger.trace("Testing handler adapter [{}]", (Object)ha);
            }
            if (!ha.supports(handler)) continue;
            return ha;
        }
        throw new ServletException("No adapter for handler [" + handler + "]: Does your handler implement a supported interface like Controller?");
    }

    protected ModelAndView processHandlerException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        HandlerExceptionResolver handlerExceptionResolver;
        ApplicationContext context = this.lookupContext(request);
        ModelAndView exMv = null;
        Map handlerExceptionResolversMap = context.getBeansOfType(HandlerExceptionResolver.class);
        Iterator iterator = handlerExceptionResolversMap.values().iterator();
        while (iterator.hasNext() && (exMv = (handlerExceptionResolver = (HandlerExceptionResolver)iterator.next()).resolveException(request, response, handler, ex)) == null) {
        }
        if (exMv != null) {
            if (exMv.isEmpty()) {
                return null;
            }
            if (!exMv.hasView()) {
                exMv.setViewName(this.getDefaultViewName(request));
            }
            WebUtils.exposeErrorRequestAttributes((HttpServletRequest)request, (Throwable)ex, (String)this.getServletName());
            return exMv;
        }
        throw ex;
    }
}

