/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.soap.util;

import com.wavemaker.runtime.soap.SoapServiceSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.ws.BindingProvider;
import org.apache.commons.lang3.StringUtils;

public class SoapSettingsResolver {
    private SoapSettingsResolver() {
    }

    public static void setBindingProperties(BindingProvider service, SoapServiceSettings bindingProperties) {
        if (bindingProperties != null) {
            Map<String, Object> customProperties;
            Map<String, String> httpHeaders;
            Map requestContext = service.getRequestContext();
            if (StringUtils.isNotEmpty((CharSequence)bindingProperties.getEndpointAddress())) {
                requestContext.put("javax.xml.ws.service.endpoint.address", bindingProperties.getEndpointAddress());
            }
            if (StringUtils.isNotEmpty((CharSequence)bindingProperties.getHttpBasicAuthUsername())) {
                requestContext.put("javax.xml.ws.security.auth.username", bindingProperties.getHttpBasicAuthUsername());
                requestContext.put("javax.xml.ws.security.auth.password", bindingProperties.getHttpBasicAuthPassword());
            }
            requestContext.put("com.sun.xml.internal.ws.connect.timeout", bindingProperties.getConnectionTimeout());
            requestContext.put("com.sun.xml.internal.ws.request.timeout", bindingProperties.getRequestTimeout());
            if (StringUtils.isNotEmpty((CharSequence)bindingProperties.getSoapActionURI())) {
                requestContext.put("javax.xml.ws.soap.http.soapaction.use", true);
                requestContext.put("javax.xml.ws.soap.http.soapaction.uri", bindingProperties.getSoapActionURI());
            }
            if ((httpHeaders = bindingProperties.getHttpHeaders()) != null && !httpHeaders.isEmpty()) {
                HashMap reqHeaders = (HashMap)requestContext.get("javax.xml.ws.http.request.headers");
                if (reqHeaders == null) {
                    reqHeaders = new HashMap();
                    requestContext.put("javax.xml.ws.http.request.headers", reqHeaders);
                }
                for (Map.Entry<String, Object> entry : httpHeaders.entrySet()) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add((String)entry.getValue());
                    reqHeaders.put(entry.getKey(), list);
                }
            }
            if ((customProperties = bindingProperties.getRequestContextProperties()) != null && !customProperties.isEmpty()) {
                for (Map.Entry<String, Object> entry : customProperties.entrySet()) {
                    requestContext.put(entry.getKey(), entry.getValue());
                }
            }
        }
    }
}

