/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.plugin.commons;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.commons.io.Folder;
import com.wavemaker.plugin.commons.LogUtil;
import com.wavemaker.plugin.commons.StudioClientUtil;
import java.io.Console;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.commons.validator.routines.EmailValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

public class AuthUtil {
    private static final Logger logger = LoggerFactory.getLogger(AuthUtil.class);
    private static String AUTH_COOKIE;

    private AuthUtil() {
    }

    public static void logOut(Folder projectFolder) {
        try {
            Properties configProperties;
            if (StringUtils.isNotEmpty((CharSequence)AUTH_COOKIE) && (configProperties = StudioClientUtil.getConfigProperties(projectFolder)) != null && configProperties.containsKey("baseUrl")) {
                String logOutUrl = StrSubstitutor.replace((Object)"${baseUrl}/login/signout", (Properties)configProperties);
                RestTemplate restTemplate = new RestTemplate();
                HttpHeaders httpHeaders = new HttpHeaders();
                httpHeaders.add("Cookie", AUTH_COOKIE);
                HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)httpHeaders);
                logger.debug("Sending logOut request to server");
                ResponseEntity responseEntity = restTemplate.exchange(logOutUrl, HttpMethod.GET, requestEntity, String.class, new Object[0]);
                logger.debug("Server Response {} ", (Object)responseEntity.getStatusCode());
            }
        }
        catch (Exception e) {
            LogUtil.userStdoutWarn("Failed to logout from user session", new Object[0]);
        }
    }

    public static String getAuthCookie(Folder projectFolder) {
        if (AUTH_COOKIE == null) {
            return AuthUtil.getAuthCookie0(projectFolder);
        }
        return AUTH_COOKIE;
    }

    public static String getAuthCookie(Properties configProperties) {
        String authCookie;
        do {
            if (configProperties.getProperty("authType") == null) {
                configProperties.put("authType", AuthUtil.getAuthType());
            }
            if ("USERNAME_PASSWORD".equals(configProperties.getProperty("authType"))) {
                authCookie = AuthUtil.getAuthCookieUsingUsernamePassword(configProperties);
                LogUtil.userStdout("Log in successful.", new Object[0]);
                continue;
            }
            authCookie = AuthUtil.getAuthCookieUsingToken(configProperties);
        } while (authCookie == null);
        return authCookie;
    }

    private static String getAuthCookie0(Folder projectFolder) {
        Properties configProperties = StudioClientUtil.getConfigProperties(projectFolder);
        String authCookie = AuthUtil.getAuthCookie(configProperties);
        StudioClientUtil.setConfigProperties(projectFolder, configProperties);
        return authCookie;
    }

    private static String getAuthType() {
        LogUtil.userStdout("Choose the Authentication type \n\t1.Username & Password \n\t2.Token \n", new Object[0]);
        while (true) {
            try {
                while (true) {
                    int authType;
                    if ((authType = Integer.parseInt(LogUtil.userStdin("Enter your choice (1/2) : ", new Object[0]))) == 1) {
                        return "USERNAME_PASSWORD";
                    }
                    if (authType == 2) {
                        return "TOKEN";
                    }
                    LogUtil.userStdout("Invalid choice, select a valid option\n", new Object[0]);
                }
            }
            catch (NumberFormatException e) {
                LogUtil.userStdout("Invalid choice, select a valid option\n", new Object[0]);
                continue;
            }
            break;
        }
    }

    private static String getAuthCookieUsingUsernamePassword(Properties configProperties) {
        String baseUrl = configProperties.getProperty("baseUrl");
        String username = configProperties.getProperty("emailId");
        ResponseEntity responseEntity = null;
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap formData = new LinkedMultiValueMap();
        String password = AuthUtil.deCode(configProperties.getProperty("password_hash"));
        Console console = System.console();
        try {
            if (configProperties.getProperty("emailId") == null) {
                EmailValidator emailValidator = EmailValidator.getInstance();
                while (!emailValidator.isValid(username = LogUtil.userStdin("\nRegistered user email: ", new Object[0]))) {
                    LogUtil.userStdoutWarn("\n Please enter a valid emailId", new Object[0]);
                }
            }
            if (password == null) {
                while (!StringUtils.isNotBlank((CharSequence)(password = new String(console.readPassword("Password: ", new Object[0])).trim()))) {
                    LogUtil.userStdoutWarn("\nPassword cannot be empty. Please enter a valid password.\n", new Object[0]);
                }
            }
            LogUtil.userStdout("\nLogging into {}, with username '{}'", baseUrl, username);
            formData.put((Object)"j_username", Collections.singletonList(username));
            formData.put((Object)"j_password", Collections.singletonList(password));
            HttpEntity httpEntity = new HttpEntity((Object)formData, (MultiValueMap)headers);
            Map<String, String> data = Collections.singletonMap("baseUrl", baseUrl);
            String loginUrl = StrSubstitutor.replace((Object)"${baseUrl}/login/authenticate", data);
            responseEntity = restTemplate.exchange(loginUrl, HttpMethod.POST, httpEntity, String.class, new Object[0]);
            List cookieHeaders = responseEntity.getHeaders().get((Object)"Set-Cookie");
            block4: for (String cookieHeader : cookieHeaders) {
                StringTokenizer st = new StringTokenizer(cookieHeader, ";");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (!token.contains("auth_cookie")) continue;
                    AUTH_COOKIE = token;
                    configProperties.put("emailId", username);
                    configProperties.put("password_hash", AuthUtil.encode(password));
                    continue block4;
                }
            }
            return AUTH_COOKIE;
        }
        catch (HttpStatusCodeException e) {
            if (e.getStatusCode() != HttpStatus.UNAUTHORIZED) {
                throw new WMRuntimeException((Throwable)e);
            }
            configProperties.remove("password_hash");
            configProperties.remove("authType");
            LogUtil.userStdoutWarn("Invalid username/password or existing password got expired\n", new Object[0]);
            return null;
        }
    }

    private static String getAuthCookieUsingToken(Properties configProperties) {
        String cookie;
        String token = AuthUtil.deCode(configProperties.getProperty("token_hash"));
        if (token == null) {
            String tokenUrl = StrSubstitutor.replace((Object)"${baseUrl}/studio/services/auth/token", (Properties)configProperties);
            LogUtil.userStdout("\nFollow the below steps to retrieve the token:\n 1. Open the browser and Login to WaveMaker \"{}\".\n 2. Post login, enter the following URL in the browser: \"{}\".\n 3. Copy the token value from the above request and enter it below.\n(Please make sure that you DO NOT logout the WaveMaker session in the browser)\n", configProperties.getProperty("baseUrl"), tokenUrl);
            token = LogUtil.userStdin("Token Value: ", new Object[0]);
        }
        if (AuthUtil.isValidAuthCookie(cookie = "auth_cookie=" + token, configProperties)) {
            configProperties.put("token_hash", AuthUtil.encode(token));
            return cookie;
        }
        configProperties.remove("token_hash");
        configProperties.remove("authType");
        LogUtil.userStdoutWarn("Invalid Token or existing Token got expired.\n", new Object[0]);
        return null;
    }

    private static boolean isValidAuthCookie(String authCookie, Properties configProperties) {
        try {
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.add("Cookie", authCookie);
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)httpHeaders);
            String userDetailUrl = StrSubstitutor.replace((Object)"${baseUrl}/studio/services/auth/loggedinuserdetails", (Properties)configProperties);
            RestTemplate restTemplate = new RestTemplate();
            ResponseEntity responseEntity = restTemplate.exchange(userDetailUrl, HttpMethod.GET, httpEntity, String.class, new Object[0]);
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode jsonNode = objectMapper.readTree((String)responseEntity.getBody());
            if (jsonNode.get("loggedIn").asBoolean(false)) {
                configProperties.setProperty("emailId", jsonNode.get("user").get("email").asText());
                return true;
            }
        }
        catch (Exception e) {
            throw new WMRuntimeException(MessageResource.INVALID_JSON, (Throwable)e);
        }
        return false;
    }

    private static String encode(String value) {
        if (value != null) {
            return new String(Base64.getEncoder().encode(value.getBytes()));
        }
        return null;
    }

    private static String deCode(String value) {
        if (value != null) {
            return new String(Base64.getDecoder().decode(value.getBytes()));
        }
        return null;
    }
}

