/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.plugin.commons;

import java.io.Console;
import org.fusesource.jansi.Ansi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class LogUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogUtil.class);

    public static void userStdout(String format, Object ... args) {
        FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])args);
        LOGGER.info(ft.getMessage());
    }

    public static void userStdoutWarn(String format, Object ... args) {
        FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])args);
        System.out.println(Ansi.ansi().fg(Ansi.Color.RED));
        LOGGER.warn(ft.getMessage());
        System.out.println(Ansi.ansi().reset());
    }

    public static String userStdin(String format, Object ... args) {
        FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])args);
        Console console = System.console();
        String userInput = console.readLine(ft.getMessage(), new Object[0]);
        userInput = userInput.trim();
        return userInput;
    }
}

