/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.plugin.commons;

import com.wavemaker.commons.io.File;
import com.wavemaker.commons.io.Folder;
import com.wavemaker.commons.properties.PropertiesWriter;
import com.wavemaker.commons.util.PropertiesFileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.text.StringSubstitutor;

public class StudioClientUtil {
    private static Properties configProperties;

    private StudioClientUtil() {
    }

    public static String getPullUrl(Folder projectFolder, String headCommitId) {
        Properties configProperties = StudioClientUtil.getConfigProperties(projectFolder);
        if (configProperties != null) {
            configProperties.put("headCommitId", headCommitId);
        }
        return StringSubstitutor.replace((Object)"${baseUrl}/studio/services/projects/${projectId}/vcs/remoteChanges?headCommitId=${headCommitId}", (Properties)configProperties);
    }

    public static String getPushUrl(Folder projectFolder) {
        Properties configProperties = StudioClientUtil.getConfigProperties(projectFolder);
        return StringSubstitutor.replace((Object)"${baseUrl}/studio/services/projects/${projectId}/vcs/applyPatch", (Properties)configProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getConfigProperties(Folder projectFolder) {
        Class<StudioClientUtil> clazz = StudioClientUtil.class;
        synchronized (StudioClientUtil.class) {
            if (configProperties == null) {
                File configPropertiesFile = StudioClientUtil.getConfigPropertiesFile(projectFolder);
                if (configPropertiesFile == null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return null;
                }
                configProperties = PropertiesFileUtils.loadProperties((File)configPropertiesFile);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return configProperties;
        }
    }

    public static synchronized void setConfigProperties(Folder projectFolder, Properties configProperties) {
        if (StudioClientUtil.getConfigPropertiesFile(projectFolder) != null) {
            PropertiesWriter.newWriter((Properties)configProperties).setSortProperties(true).setSansDate(true).write(Objects.requireNonNull(StudioClientUtil.getConfigPropertiesFile(projectFolder)).getContent().asOutputStream());
        }
        StudioClientUtil.configProperties = configProperties;
    }

    private static File getConfigPropertiesFile(Folder projectFolder) {
        Folder projectGitFolder = projectFolder.getFolder(".git");
        Folder wMFolder = projectGitFolder.getFolder("wm");
        if (wMFolder.exists()) {
            return wMFolder.getFile("config");
        }
        return null;
    }

    public static String getAuthType(Folder projectFolder) {
        Properties configProperties = StudioClientUtil.getConfigProperties(projectFolder);
        return configProperties == null ? null : configProperties.getProperty("authType");
    }

    public static CountingInputStream getCountingInputStream(InputStream inputStream, final long maxLength) {
        return new CountingInputStream(inputStream){

            protected synchronized void afterRead(int n) {
                super.afterRead(n);
                if (maxLength != -1L) {
                    long percent = (long)this.getCount() * 100L / maxLength;
                    System.out.print("\r Downloaded bytes " + this.getCount() + "/" + maxLength + "(" + percent + "%)");
                } else {
                    System.out.print("\r Downloaded bytes " + this.getCount());
                }
            }

            public void close() throws IOException {
                super.close();
                System.out.println();
            }
        };
    }
}

