/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.hawk.jersey;

import com.google.inject.Inject;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.wealdtech.Preconditions;
import com.wealdtech.hawk.HawkClient;
import java.net.URI;

public class HawkAuthorizationFilter
extends ClientFilter {
    private final transient HawkClient client;

    @Inject
    public HawkAuthorizationFilter(HawkClient client) {
        Preconditions.checkNotNull((Object)client, (Object)"Hawk authorization filter requires a hawk client");
        this.client = client;
    }

    public ClientResponse handle(ClientRequest cr) {
        if (!cr.getHeaders().containsKey((Object)"Authorization") && this.client.isValidFor(cr.getURI().getRawPath())) {
            URI uri = cr.getURI();
            String method = cr.getMethod();
            cr.getHeaders().add((Object)"Authorization", (Object)this.client.generateAuthorizationHeader(uri, method, null, null, null, null));
        }
        return this.getNext().handle(cr);
    }
}

