/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.wealdtech.DataError;
import com.wealdtech.jackson.ObjectMapperFactory;
import com.wealdtech.utils.ResourceLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationSource<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationSource.class);
    private static final String DEFAULTFILENAME = "config.json";

    public T getConfiguration(Class<T> klazz) {
        return this.getConfiguration(DEFAULTFILENAME, klazz);
    }

    public T getConfiguration(String filename, Class<T> klazz) {
        ObjectMapper mapper = ObjectMapperFactory.getDefaultMapper();
        try {
            return (T)mapper.readValue(ConfigurationSource.readFile(filename), klazz);
        }
        catch (IOException ioe) {
            LOGGER.error("Failed to parse JSON configuration file: {}", (Object)ioe.getLocalizedMessage(), (Object)ioe);
            throw new DataError("Failed to parse JSON configuration file", (Throwable)ioe);
        }
    }

    private static String readFile(String filename) {
        StringBuilder content = new StringBuilder();
        String linefeed = System.getProperty("line.separator");
        try (BufferedReader reader = ConfigurationSource.getReader(filename);){
            String line;
            if (reader == null) {
                throw new DataError("Failed to find resource \"" + filename + "\"");
            }
            while ((line = reader.readLine()) != null) {
                content.append(line).append(linefeed);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to read file: {}", (Object)e.getLocalizedMessage());
            LOGGER.warn("Stack trace: {}", (Throwable)e);
            throw new DataError("Failed to read file: " + e.getLocalizedMessage(), (Throwable)e);
        }
        return content.toString();
    }

    private static BufferedReader getReader(String filename) {
        URL fileurl = ResourceLoader.getResource((String)filename);
        if (fileurl == null) {
            return null;
        }
        try {
            return Files.newBufferedReader(Paths.get(fileurl.toURI()), Charset.defaultCharset());
        }
        catch (IOException ioe) {
            LOGGER.warn("IO exception with {}: {}", (Object)fileurl, (Object)ioe);
            throw new DataError("Failed to access configuration file \"" + filename + "\"", (Throwable)ioe);
        }
        catch (URISyntaxException use) {
            LOGGER.warn("URI issue with {}: {}", (Object)fileurl, (Object)use);
            throw new DataError("Failed to access configuration file \"" + filename + "\"", (Throwable)use);
        }
    }
}

