/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.configuration;

import ch.qos.logback.classic.Level;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.wealdtech.configuration.Configuration;

public class LoggingConfiguration
implements Configuration {
    private Level level = Level.INFO;
    private ImmutableMap<String, Level> overrides = ImmutableMap.of();
    private String pattern = "%d{yyyyMMdd'T'HH:mm:ss.SSS} [%thread] %-5level %logger{36} - %msg%n";

    @Inject
    public LoggingConfiguration() {
    }

    @JsonCreator
    private LoggingConfiguration(@JsonProperty(value="level") Level level, @JsonProperty(value="overrides") ImmutableMap<String, Level> overrides, @JsonProperty(value="pattern") String pattern) {
        this.level = (Level)Objects.firstNonNull((Object)level, (Object)this.level);
        this.overrides = (ImmutableMap)Objects.firstNonNull(overrides, this.overrides);
        this.pattern = (String)Objects.firstNonNull((Object)pattern, (Object)this.pattern);
    }

    public Level getLevel() {
        return this.level;
    }

    public ImmutableMap<String, Level> getOverrides() {
        return this.overrides;
    }

    public String getPattern() {
        return this.pattern;
    }

    public static class Builder {
        private Level level;
        private ImmutableMap<String, Level> overrides;
        private String pattern;

        public Builder() {
        }

        public Builder(LoggingConfiguration prior) {
            this.level = prior.level;
            this.overrides = prior.overrides;
            this.pattern = prior.pattern;
        }

        public Builder level(Level level) {
            this.level = level;
            return this;
        }

        public Builder overrides(ImmutableMap<String, Level> overrides) {
            this.overrides = overrides;
            return this;
        }

        public Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public LoggingConfiguration build() {
            return new LoggingConfiguration(this.level, this.overrides, this.pattern);
        }
    }
}

