/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.AbstractIterator;
import com.wealdtech.Absent;
import com.wealdtech.Clear;
import com.wealdtech.Preconditions;
import com.wealdtech.Present;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class TriVal<T>
implements Serializable {
    private static final long serialVersionUID = 0L;

    public static <T> TriVal<T> clear() {
        return Clear.INSTANCE;
    }

    public static <T> TriVal<T> absent() {
        return Absent.INSTANCE;
    }

    public static <T> TriVal<T> of(T reference) {
        return new Present<T>(Preconditions.checkNotNull(reference));
    }

    public static <T> TriVal<T> fromNullable(@Nullable T nullableReference) {
        return nullableReference == null ? TriVal.absent() : new Present<T>(nullableReference);
    }

    TriVal() {
    }

    public abstract boolean isPresent();

    public abstract boolean isAbsent();

    public abstract boolean isClear();

    public abstract T get();

    public abstract T or(T var1);

    public abstract TriVal<T> or(TriVal<? extends T> var1);

    @Beta
    public abstract T or(Supplier<? extends T> var1);

    @Nullable
    public abstract T orNull();

    public abstract Set<T> asSet();

    public abstract <V> TriVal<V> transform(Function<? super T, V> var1);

    public abstract boolean equals(@Nullable Object var1);

    public abstract int hashCode();

    public abstract String toString();

    @Beta
    public static <T> Iterable<T> presentInstances(final Iterable<? extends TriVal<? extends T>> TriVals) {
        Preconditions.checkNotNull(TriVals);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new AbstractIterator<T>(){
                    private final Iterator<? extends TriVal<? extends T>> iterator;
                    {
                        this.iterator = Preconditions.checkNotNull(TriVals.iterator());
                    }

                    protected T computeNext() {
                        while (this.iterator.hasNext()) {
                            TriVal TriVal2 = this.iterator.next();
                            if (!TriVal2.isPresent()) continue;
                            return TriVal2.get();
                        }
                        return this.endOfData();
                    }
                };
            }
        };
    }
}

