/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.primitives.Longs;
import com.wealdtech.DataError;
import com.wealdtech.Preconditions;
import java.io.Serializable;
import java.util.Random;

public class WID<T>
implements Comparable<WID<T>>,
Serializable {
    private static final long serialVersionUID = 6897379549693105270L;
    public static final long EPOCH = 1325376000000L;
    private static final long SHARDMASK = -2533274790395904L;
    private static final int SHARDOFFSET = 51;
    private static final int SHARDSIZE = 12;
    public static final long MAX_SHARD = 4095L;
    private static final long TIMESTAMPMASK = 1125899906841600L;
    private static final int TIMESTAMPOFFSET = 10;
    private static final int TIMESTAMPSIZE = 41;
    public static final long MAX_TIMESTAMP = 0x1FFFFFFFFFFL;
    private static final long IIDMASK = 1023L;
    private static final int IIDSIZE = 10;
    public static final long MAX_IID = 1023L;
    private static final int RADIX = 16;
    private final long id;

    public WID(long wid) {
        this.id = wid;
    }

    @JsonIgnore
    public long getShardId() {
        return (this.id & 0xFFF7000000000000L) >> 51;
    }

    @JsonIgnore
    public long getTimestamp() {
        return ((this.id & 0x3FFFFFFFFFC00L) >> 10) + 1325376000000L;
    }

    @JsonIgnore
    public long getIid() {
        return this.id & 0x3FFL;
    }

    public long toLong() {
        return this.id;
    }

    public static <T> WID<T> fromString(String input) {
        Preconditions.checkNotNull(input, "Passed NULL WID");
        try {
            return new WID<T>(Long.valueOf(input, 16));
        }
        catch (NumberFormatException nfe) {
            throw new DataError.Bad("Failed to parse WID \"" + input + "\"", nfe);
        }
    }

    public static <T> WID<T> fromComponents(long shardId, long timestamp, long id) {
        long adjustedTimestamp = timestamp - 1325376000000L;
        Preconditions.checkArgument(shardId >= 0L && shardId < 4095L, "Shard ID %s out of range %s", shardId);
        Preconditions.checkArgument(timestamp >= 1325376000000L && adjustedTimestamp < 0x1FFFFFFFFFFL, "Timestamp %s out of range %s", timestamp, 0x1FFFFFFFFFFL);
        Preconditions.checkArgument(id >= 0L && id < 1023L, "ID %s out of range", id);
        return new WID<T>(shardId << 51 & 0xFFF7000000000000L | adjustedTimestamp << 10 & 0x3FFFFFFFFFC00L | id & 0x3FFL);
    }

    public static <T> WID<T> fromLong(Long input) {
        Preconditions.checkNotNull(input, "Passed NULL WID");
        return new WID<T>(input);
    }

    public static <T> WID<T> randomWID() {
        Random random = new Random();
        long shardId = random.nextInt(4095);
        long timestamp = System.currentTimeMillis();
        long id = random.nextInt(1023);
        return WID.fromComponents(shardId, timestamp, id);
    }

    public String toString() {
        return Long.toHexString(this.id);
    }

    public int hashCode() {
        return Longs.hashCode((long)this.id);
    }

    public boolean equals(Object that) {
        return that instanceof WID && this.id == ((WID)that).id;
    }

    @Override
    public int compareTo(WID<T> that) {
        return this.id < that.id ? -1 : (this.id > that.id ? 1 : 0);
    }
}

