/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech;

public abstract class WealdError
extends RuntimeException {
    private static final long serialVersionUID = -8127456058290412830L;
    protected static final String BASEURL = "http://developers.wealdtech.com/docs/";
    private final String userMessage;
    private final String url;

    public WealdError(String message, String userMessage, String url, Throwable t) {
        super(message, t);
        this.userMessage = userMessage;
        this.url = url;
    }

    @Override
    public String toString() {
        String s = this.getClass().getName();
        String message = this.getLocalizedMessage();
        return message != null ? message : s;
    }

    public String getUserMessage() {
        return this.userMessage;
    }

    public String getUrl() {
        return this.url;
    }

    public String getThrowingClassName() {
        String result = null;
        StackTraceElement[] stacktrace = this.getStackTrace();
        if (stacktrace.length > 0) {
            result = stacktrace[0].getClassName();
        }
        return result;
    }

    public String getThrowingMethodName() {
        String result = null;
        StackTraceElement[] stacktrace = this.getStackTrace();
        if (stacktrace.length > 0) {
            result = stacktrace[0].getMethodName();
        }
        return result;
    }
}

