/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.errors;

import com.google.common.base.Objects;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import com.wealdtech.DataError;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorInfo
implements Comparable<ErrorInfo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorInfo.class);
    private final String userMessage;
    private final String developerMessage;
    private final String errorCode;
    private final URI moreInfo;

    public ErrorInfo(String errorCode, String userMessage, String developerMessage, URI moreInfo) {
        this.errorCode = errorCode;
        this.userMessage = userMessage;
        this.developerMessage = developerMessage;
        this.moreInfo = moreInfo;
    }

    public ErrorInfo(String errorCode, String userMessage, String developerMessage, String moreInfo) {
        this.errorCode = errorCode;
        this.userMessage = userMessage;
        this.developerMessage = developerMessage;
        URI moreInfoUri = null;
        if (moreInfo != null) {
            try {
                moreInfoUri = new URI(moreInfo);
            }
            catch (URISyntaxException use) {
                LOGGER.warn("Failed to parse {} in to a valid URI", (Object)moreInfo, (Object)use);
                throw new DataError.Bad("Attempt to create error info with bad URI", use);
            }
        }
        this.moreInfo = moreInfoUri;
    }

    public final String getErrorCode() {
        return this.errorCode;
    }

    public final String getUserMessage() {
        return this.userMessage;
    }

    public final String getDeveloperMessage() {
        return this.developerMessage;
    }

    public final URI getMoreInfo() {
        return this.moreInfo;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("errorCode", (Object)this.errorCode).add("userMessage", (Object)this.userMessage).add("developerMessage", (Object)this.developerMessage).add("moreInfo", (Object)this.moreInfo).toString();
    }

    public boolean equals(Object that) {
        return that instanceof ErrorInfo && this.compareTo((ErrorInfo)that) == 0;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.errorCode, this.userMessage, this.developerMessage, this.moreInfo});
    }

    @Override
    public int compareTo(ErrorInfo that) {
        return ComparisonChain.start().compare((Object)this.errorCode, (Object)that.errorCode, (Comparator)Ordering.natural().nullsFirst()).compare((Object)this.userMessage, (Object)that.userMessage, (Comparator)Ordering.natural().nullsFirst()).compare((Object)this.developerMessage, (Object)that.developerMessage, (Comparator)Ordering.natural().nullsFirst()).compare((Object)this.moreInfo, (Object)that.moreInfo, (Comparator)Ordering.natural().nullsFirst()).result();
    }
}

