/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.wealdtech.jackson.ObjectMapperConfiguration;
import com.wealdtech.jackson.ObjectMapperFactory;

public enum WealdMapper {
    INSTANCE;

    private static final transient ObjectMapper CLIENTMAPPER;
    private static final transient ObjectMapper SERVERMAPPER;

    public static ObjectMapper getMapper() {
        return CLIENTMAPPER;
    }

    public static ObjectMapper getServerMapper() {
        return SERVERMAPPER;
    }

    static {
        ObjectMapperConfiguration clientconfiguration = new ObjectMapperConfiguration();
        clientconfiguration.addInjectableValue("AllowPartials", Boolean.FALSE);
        clientconfiguration.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        CLIENTMAPPER = new ObjectMapperFactory().build(clientconfiguration);
        ObjectMapperConfiguration serverconfiguration = new ObjectMapperConfiguration();
        serverconfiguration.addInjectableValue("AllowPartials", Boolean.TRUE);
        serverconfiguration.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        SERVERMAPPER = new ObjectMapperFactory().build(serverconfiguration);
    }
}

