/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jackson.modules;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeDeserializer
extends JsonDeserializer<DateTime> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateTimeDeserializer.class);
    private static DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZ");
    private static DateTimeZone utczone = DateTimeZone.forID((String)"UTC");

    public DateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ObjectCodec oc = jsonParser.getCodec();
        JsonNode node = (JsonNode)oc.readTree(jsonParser);
        JsonNode datetimenode = node.get("datetime");
        if (datetimenode == null) {
            LOGGER.warn("Attempt to deserialize malformed datetime");
            throw new IOException("Invalid datettime value");
        }
        String datetime = datetimenode.textValue();
        JsonNode tznode = node.get("timezone");
        String timezone = null;
        if (tznode != null) {
            timezone = tznode.textValue();
        }
        DateTime result = null;
        try {
            result = timezone == null || "UTC".equals(timezone) ? formatter.parseDateTime(datetime).withZone(utczone) : formatter.parseDateTime(datetime).withZone(DateTimeZone.forID((String)timezone));
        }
        catch (IllegalArgumentException iae) {
            LOGGER.warn("Attempt to deserialize invalid datetime {},{}", (Object)datetime, (Object)timezone);
            throw new IOException("Invalid datetime value", iae);
        }
        return result;
    }
}

