/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jackson.modules;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class IntervalSerializer
extends StdSerializer<Interval> {
    private static DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZ");

    public IntervalSerializer() {
        super(Interval.class, true);
    }

    public void serialize(Interval value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("startdatetime", formatter.print((ReadableInstant)value.getStart()));
        gen.writeStringField("starttimezone", value.getStart().getZone().toString());
        gen.writeStringField("enddatetime", formatter.print((ReadableInstant)value.getEnd()));
        gen.writeStringField("endtimezone", value.getEnd().getZone().toString());
        gen.writeEndObject();
    }
}

