/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jackson.modules;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.wealdtech.DataError;
import com.wealdtech.jackson.WealdMapper;
import com.wealdtech.utils.messaging.MessageObjects;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageObjectsDeserializer
extends StdDeserializer<MessageObjects<?>> {
    private static final long serialVersionUID = -8937155316970465927L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageObjectsDeserializer.class);

    public MessageObjectsDeserializer() {
        super(MessageObjects.class);
    }

    public MessageObjects<? extends Object> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        Class<?> objclass;
        jp.nextToken();
        String fieldname = jp.getCurrentName();
        if (!"_type".equals(fieldname)) {
            throw new IOException("Unexpected key \"" + fieldname + "\"; expected _type");
        }
        jp.nextToken();
        String typestr = jp.getText();
        try {
            objclass = Class.forName(typestr);
        }
        catch (ClassNotFoundException cnfe) {
            LOGGER.error("MessageObjects has unknown class: \"" + typestr + "\"");
            throw new IOException("MessageObjects has unknown class", cnfe);
        }
        jp.nextToken();
        fieldname = jp.getCurrentName();
        Object prior = null;
        if ("prior".equals(fieldname)) {
            jp.nextToken();
            prior = WealdMapper.getMapper().readValue(jp, objclass);
            jp.nextToken();
            fieldname = jp.getCurrentName();
        }
        Object current = null;
        if ("current".equals(fieldname)) {
            jp.nextToken();
            current = WealdMapper.getMapper().readValue(jp, objclass);
        }
        try {
            return new MessageObjects<Object>(prior, current);
        }
        catch (DataError de) {
            LOGGER.error("Failed to instantiate MessageObjects: \"" + de.getLocalizedMessage() + "\"");
            throw new IOException("Failed to instantiate MessageObjects", de);
        }
    }
}

