/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jackson.modules;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.wealdtech.WID;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class WIDDeserializer
extends FromStringDeserializer<WID<?>> {
    private static final long serialVersionUID = -8771787639009660187L;
    private static final int WID_BINARY_SIZE = 8;

    public WIDDeserializer() {
        super(WID.class);
    }

    protected WID<?> _deserialize(String value, DeserializationContext ctxt) throws IOException {
        return WID.fromString(value);
    }

    protected WID<?> _deserializeEmbedded(Object ob, DeserializationContext ctxt) throws IOException {
        if (ob instanceof byte[]) {
            byte[] bytes = (byte[])ob;
            if (bytes.length != 8) {
                ctxt.mappingException("Can only construct WIDs from 8 byte arrays");
            }
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
            return new WID(in.readLong());
        }
        super._deserializeEmbedded(ob, ctxt);
        return null;
    }
}

