/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jackson.modules;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.deser.KeyDeserializers;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleKeyDeserializers;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.wealdtech.WID;
import com.wealdtech.jackson.modules.WIDDeserializer;
import com.wealdtech.jackson.modules.WIDKeyDeserializer;
import com.wealdtech.jackson.modules.WIDKeySerializer;
import com.wealdtech.jackson.modules.WIDSerializer;

public class WealdIDModule
extends Module {
    private static final transient String NAME = "WealdIDModule";
    private transient Version version;

    public String getModuleName() {
        return NAME;
    }

    public Version version() {
        if (this.version == null) {
            this.version = new Version(1, 0, 0, null, "com.wealdtech", "utils");
        }
        return this.version;
    }

    public void setupModule(Module.SetupContext context) {
        SimpleSerializers serializers = new SimpleSerializers();
        serializers.addSerializer((JsonSerializer)new WIDSerializer());
        SimpleDeserializers deserializers = new SimpleDeserializers();
        deserializers.addDeserializer(WID.class, (JsonDeserializer)new WIDDeserializer());
        SimpleSerializers keySerializers = new SimpleSerializers();
        keySerializers.addSerializer((JsonSerializer)new WIDKeySerializer());
        SimpleKeyDeserializers keyDeserializers = new SimpleKeyDeserializers();
        keyDeserializers.addDeserializer(WID.class, (KeyDeserializer)new WIDKeyDeserializer());
        context.addSerializers((Serializers)serializers);
        context.addDeserializers((Deserializers)deserializers);
        context.addKeySerializers((Serializers)keySerializers);
        context.addKeyDeserializers((KeyDeserializers)keyDeserializers);
    }
}

