/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jackson.modules;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.wealdtech.jackson.modules.DateTimeDeserializer;
import com.wealdtech.jackson.modules.DateTimeSerializer;
import com.wealdtech.jackson.modules.IntervalDeserializer;
import com.wealdtech.jackson.modules.IntervalSerializer;
import com.wealdtech.jackson.modules.LocalDateDeserializer;
import com.wealdtech.jackson.modules.LocalDateSerializer;
import com.wealdtech.jackson.modules.LocalDateTimeDeserializer;
import com.wealdtech.jackson.modules.LocalDateTimeSerializer;
import com.wealdtech.jackson.modules.PeriodDeserializer;
import com.wealdtech.jackson.modules.PeriodSerializer;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.Period;

public class WealdJodaModule
extends Module {
    private static final transient String NAME = "WealdModule";
    private transient Version version;

    public String getModuleName() {
        return NAME;
    }

    public Version version() {
        if (this.version == null) {
            this.version = new Version(1, 0, 0, null, "com.wealdtech", "utils");
        }
        return this.version;
    }

    public void setupModule(Module.SetupContext context) {
        SimpleSerializers serializers = new SimpleSerializers();
        SimpleDeserializers deserializers = new SimpleDeserializers();
        serializers.addSerializer((JsonSerializer)new PeriodSerializer());
        deserializers.addDeserializer(Period.class, (JsonDeserializer)new PeriodDeserializer());
        serializers.addSerializer((JsonSerializer)new DateTimeSerializer());
        deserializers.addDeserializer(DateTime.class, (JsonDeserializer)new DateTimeDeserializer());
        serializers.addSerializer((JsonSerializer)new LocalDateTimeSerializer());
        deserializers.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer());
        serializers.addSerializer((JsonSerializer)new LocalDateSerializer());
        deserializers.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer());
        serializers.addSerializer((JsonSerializer)new IntervalSerializer());
        deserializers.addDeserializer(Interval.class, (JsonDeserializer)new IntervalDeserializer());
        context.addSerializers((Serializers)serializers);
        context.addDeserializers((Deserializers)deserializers);
    }
}

