/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jackson.modules;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.wealdtech.jackson.modules.InetSocketAddressDeserializer;
import com.wealdtech.jackson.modules.InetSocketAddressSerializer;
import com.wealdtech.jackson.modules.MessageObjectsDeserializer;
import com.wealdtech.jackson.modules.MessageObjectsSerializer;
import com.wealdtech.utils.messaging.MessageObjects;
import java.net.InetSocketAddress;

public class WealdMiscModule
extends Module {
    private static final transient String NAME = "WealdMiscModule";
    private transient Version version;

    public String getModuleName() {
        return NAME;
    }

    public Version version() {
        if (this.version == null) {
            this.version = new Version(1, 0, 0, null, "com.wealdtech", "utils");
        }
        return this.version;
    }

    public void setupModule(Module.SetupContext context) {
        SimpleSerializers serializers = new SimpleSerializers();
        serializers.addSerializer((JsonSerializer)new InetSocketAddressSerializer());
        serializers.addSerializer((JsonSerializer)new MessageObjectsSerializer());
        SimpleDeserializers deserializers = new SimpleDeserializers();
        deserializers.addDeserializer(InetSocketAddress.class, (JsonDeserializer)new InetSocketAddressDeserializer());
        deserializers.addDeserializer(MessageObjects.class, (JsonDeserializer)new MessageObjectsDeserializer());
        context.addSerializers((Serializers)serializers);
        context.addDeserializers((Deserializers)deserializers);
    }
}

