/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.schedule;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Optional;
import com.google.common.collect.ComparisonChain;
import com.wealdtech.DataError;
import com.wealdtech.Preconditions;
import com.wealdtech.utils.IntervalOrdering;
import com.wealdtech.utils.StringUtils;
import java.util.Comparator;
import java.util.Locale;
import org.joda.time.Interval;
import org.joda.time.base.BaseDateTime;

public class Alteration<T extends BaseDateTime>
implements Comparable<Alteration<T>> {
    private final AlterationType type;
    private final T start;
    private final Optional<Interval> replacement;

    public Alteration(AlterationType type, T start, Interval replacement) {
        this.type = type;
        this.start = start;
        this.replacement = Optional.fromNullable((Object)replacement);
        this.validate();
    }

    private void validate() {
        Preconditions.checkNotNull(this.type, "Alteration requires a type");
        Preconditions.checkNotNull(this.start, "Alteration requires a start");
        if (this.type == AlterationType.EXCEPTION) {
            Preconditions.checkState(!this.replacement.isPresent(), "Exception alterations should not have a replacement");
        } else {
            Preconditions.checkNotNull(this.replacement, "Non-exception alterations require a replacement");
        }
    }

    public AlterationType getType() {
        return this.type;
    }

    public T getStart() {
        return this.start;
    }

    public Optional<Interval> getReplacement() {
        return this.replacement;
    }

    @Override
    public int compareTo(Alteration<T> that) {
        return ComparisonChain.start().compare((Comparable)((Object)this.type), (Comparable)((Object)that.type)).compare(this.start, that.start).compare(this.replacement.orNull(), that.replacement.orNull(), (Comparator)IntervalOrdering.INSTANCE.nullsFirst()).result();
    }

    public static enum AlterationType {
        EXCEPTION,
        ALTERATION;


        @JsonValue
        public String toString() {
            return StringUtils.capitalize(super.toString().toLowerCase(Locale.ENGLISH));
        }

        @JsonCreator
        public static AlterationType fromString(String alterationType) {
            try {
                return AlterationType.valueOf(alterationType.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException iae) {
                throw new DataError.Bad("A schedule alteration type supplied is invalid");
            }
        }
    }
}

