/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.schedule;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.wealdtech.Preconditions;
import com.wealdtech.schedule.Alteration;
import com.wealdtech.schedule.ScheduleIterator;
import com.wealdtech.utils.Joda;
import com.wealdtech.utils.PeriodOrdering;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.base.BaseDateTime;

public class Schedule<T extends BaseDateTime>
implements Iterable<Interval>,
Comparable<Schedule<T>> {
    public static Integer ALL = new Integer(0);
    private static final ImmutableList<Integer> ALL_DAYS_OF_WEEK = ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(7)), (DiscreteDomain)DiscreteDomain.integers()).asList();
    private static final ImmutableList<Integer> ALL_WEEKS_OF_YEAR = ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(53)), (DiscreteDomain)DiscreteDomain.integers()).asList();
    private static final ImmutableList<Integer> ALL_WEEKS_OF_MONTH = ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)), (DiscreteDomain)DiscreteDomain.integers()).asList();
    private static final ImmutableList<Integer> ALL_DAYS_OF_MONTH = ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(31)), (DiscreteDomain)DiscreteDomain.integers()).asList();
    private static final ImmutableList<Integer> ALL_MONTHS_OF_YEAR = ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(12)), (DiscreteDomain)DiscreteDomain.integers()).asList();
    private static final ImmutableList<Integer> ALL_DAYS_OF_YEAR = ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(366)), (DiscreteDomain)DiscreteDomain.integers()).asList();
    private final T start;
    private final Optional<T> end;
    private final Period duration;
    private final Optional<ImmutableList<Alteration<T>>> alterations;
    private final Optional<ImmutableList<Integer>> monthsOfYear;
    private final Optional<ImmutableList<Integer>> weeksOfYear;
    private final Optional<ImmutableList<Integer>> weeksOfMonth;
    private final Optional<ImmutableList<Integer>> daysOfYear;
    private final Optional<ImmutableList<Integer>> daysOfMonth;
    private final Optional<ImmutableList<Integer>> daysOfWeek;

    public Schedule(T start, T end, Period duration, List<Alteration<T>> alterations, List<Integer> monthsOfYear, List<Integer> weeksOfYear, List<Integer> weeksOfMonth, List<Integer> daysOfYear, List<Integer> daysOfMonth, List<Integer> daysOfWeek) {
        this.start = start;
        this.end = Optional.fromNullable(end);
        this.duration = duration;
        this.alterations = alterations == null ? Optional.absent() : Optional.of((Object)ImmutableList.copyOf((Collection)Ordering.natural().immutableSortedCopy(alterations)));
        this.monthsOfYear = monthsOfYear == null || monthsOfYear.isEmpty() ? Optional.absent() : (monthsOfYear.contains(ALL) ? Optional.of(ALL_MONTHS_OF_YEAR) : Optional.of((Object)ImmutableList.copyOf((Collection)Ordering.natural().immutableSortedCopy(monthsOfYear))));
        this.weeksOfYear = weeksOfYear == null || weeksOfYear.isEmpty() ? Optional.absent() : (weeksOfYear.contains(ALL) ? Optional.of(ALL_WEEKS_OF_YEAR) : Optional.of((Object)ImmutableList.copyOf((Collection)Ordering.natural().immutableSortedCopy(weeksOfYear))));
        this.weeksOfMonth = weeksOfMonth == null || weeksOfMonth.isEmpty() ? Optional.absent() : (weeksOfMonth.contains(ALL) ? Optional.of(ALL_WEEKS_OF_MONTH) : Optional.of((Object)ImmutableList.copyOf((Collection)Ordering.natural().immutableSortedCopy(weeksOfMonth))));
        this.daysOfYear = daysOfYear == null || daysOfYear.isEmpty() ? Optional.absent() : (daysOfYear.contains(ALL) ? Optional.of(ALL_DAYS_OF_YEAR) : Optional.of((Object)ImmutableList.copyOf((Collection)Ordering.natural().immutableSortedCopy(daysOfYear))));
        this.daysOfMonth = daysOfMonth == null || daysOfMonth.isEmpty() ? Optional.absent() : (daysOfMonth.contains(ALL) ? Optional.of(ALL_DAYS_OF_MONTH) : Optional.of((Object)ImmutableList.copyOf((Collection)Ordering.natural().immutableSortedCopy(daysOfMonth))));
        this.daysOfWeek = daysOfWeek == null || daysOfWeek.isEmpty() ? Optional.absent() : (daysOfWeek.contains(ALL) ? Optional.of(ALL_DAYS_OF_WEEK) : Optional.of((Object)ImmutableList.copyOf((Collection)Ordering.natural().immutableSortedCopy(daysOfWeek))));
        this.validate();
    }

    private void validate() {
        Preconditions.checkNotNull(this.start, "Schedule requires a start");
        Preconditions.checkNotNull(this.duration, "Schedule requires a duration");
        Preconditions.checkState(this.daysOfYear.isPresent() || this.daysOfMonth.isPresent() || this.daysOfWeek.isPresent(), "Schedule requires a day");
        if (this.daysOfWeek.isPresent()) {
            Preconditions.checkState(Collections2.filter((Collection)((Collection)this.daysOfWeek.get()), (Predicate)Range.lessThan((Comparable)Integer.valueOf(0))).isEmpty(), "Days of week must not contain negative values");
            Preconditions.checkState(Collections2.filter((Collection)((Collection)this.daysOfWeek.get()), (Predicate)Range.greaterThan((Comparable)Integer.valueOf(7))).isEmpty(), "Days of week must not contain values greater than 7");
            Preconditions.checkState(this.weeksOfMonth.isPresent() && this.monthsOfYear.isPresent() || this.weeksOfYear.isPresent(), "Schedule not complete");
            Preconditions.checkState(!this.daysOfMonth.isPresent() && !this.daysOfYear.isPresent(), "Schedule cannot have multiple day items");
            Preconditions.checkState(!this.weeksOfMonth.isPresent() || !this.weeksOfYear.isPresent(), "Schedule cannot have multiple week items");
        }
        if (this.daysOfMonth.isPresent()) {
            Preconditions.checkState(Collections2.filter((Collection)((Collection)this.daysOfMonth.get()), (Predicate)Range.lessThan((Comparable)Integer.valueOf(0))).isEmpty(), "Days of month must not contain negative values");
            Preconditions.checkState(Collections2.filter((Collection)((Collection)this.daysOfMonth.get()), (Predicate)Range.greaterThan((Comparable)Integer.valueOf(31))).isEmpty(), "Days of month must not contain values greater than 31");
            Preconditions.checkState(this.monthsOfYear.isPresent(), "Schedule not complete");
            Preconditions.checkState(!this.daysOfYear.isPresent(), "Schedule cannot have multiple day items");
        }
        if (this.daysOfYear.isPresent()) {
            Preconditions.checkState(Collections2.filter((Collection)((Collection)this.daysOfYear.get()), (Predicate)Range.lessThan((Comparable)Integer.valueOf(0))).isEmpty(), "Days of year must not contain negative values");
            Preconditions.checkState(Collections2.filter((Collection)((Collection)this.daysOfYear.get()), (Predicate)Range.greaterThan((Comparable)Integer.valueOf(366))).isEmpty(), "Days of year must not contain values greater than 366");
        }
        if (this.weeksOfMonth.isPresent()) {
            Preconditions.checkState(Collections2.filter((Collection)((Collection)this.weeksOfMonth.get()), (Predicate)Range.greaterThan((Comparable)Integer.valueOf(5))).isEmpty(), "Weeks of month must not contain values greater than 4");
        }
        if (this.weeksOfYear.isPresent()) {
            Preconditions.checkState(Collections2.filter((Collection)((Collection)this.weeksOfYear.get()), (Predicate)Range.greaterThan((Comparable)Integer.valueOf(53))).isEmpty(), "Weeks of year must not contain values greater than 53");
        }
        if (this.monthsOfYear.isPresent()) {
            Preconditions.checkState(Collections2.filter((Collection)((Collection)this.monthsOfYear.get()), (Predicate)Range.greaterThan((Comparable)Integer.valueOf(12))).isEmpty(), "Months of year must not contain values greater than 12");
        }
        if (this.end.isPresent()) {
            Preconditions.checkState(this.start.isBefore((ReadableInstant)this.end.get()), "End of schedule prior to start");
        }
        Preconditions.checkState(this.isAScheduleStart(this.getStart()), "Start is not a valid schedule start");
        if (this.alterations.isPresent()) {
            for (Alteration alteration : (ImmutableList)this.alterations.get()) {
                Preconditions.checkState(this.isAScheduleStart(alteration.getStart()), "Alteration start is not a valid schedule start");
            }
        }
    }

    public boolean terminates() {
        return this.end.isPresent();
    }

    public boolean isAScheduleStart(T date) {
        if (date.getMinuteOfHour() != this.start.getMinuteOfHour() || date.getHourOfDay() != this.start.getHourOfDay()) {
            return false;
        }
        if (this.daysOfWeek.isPresent() && !((ImmutableList)this.daysOfWeek.get()).contains((Object)date.getDayOfWeek())) {
            return false;
        }
        if (this.daysOfMonth.isPresent() && !((ImmutableList)this.daysOfMonth.get()).contains((Object)date.getDayOfMonth())) {
            return false;
        }
        if (this.daysOfYear.isPresent() && !((ImmutableList)this.daysOfYear.get()).contains((Object)date.getDayOfYear())) {
            return false;
        }
        if (this.weeksOfMonth.isPresent() && !((ImmutableList)this.weeksOfMonth.get()).contains((Object)date.get(Joda.AbsWeekOfMonth))) {
            return false;
        }
        if (this.weeksOfYear.isPresent() && !((ImmutableList)this.weeksOfYear.get()).contains((Object)date.get(Joda.AbsWeekOfYear))) {
            return false;
        }
        return !this.monthsOfYear.isPresent() || ((ImmutableList)this.monthsOfYear.get()).contains((Object)date.getMonthOfYear());
    }

    public T getStart() {
        return this.start;
    }

    public Optional<T> getEnd() {
        return this.end;
    }

    public Period getDuration() {
        return this.duration;
    }

    public Optional<ImmutableList<Alteration<T>>> getAlterations() {
        return this.alterations;
    }

    public Optional<ImmutableList<Integer>> getMonthsOfYear() {
        return this.monthsOfYear;
    }

    public Optional<ImmutableList<Integer>> getWeeksOfYear() {
        return this.weeksOfYear;
    }

    public Optional<ImmutableList<Integer>> getWeeksOfMonth() {
        return this.weeksOfMonth;
    }

    public Optional<ImmutableList<Integer>> getDaysOfYear() {
        return this.daysOfYear;
    }

    public Optional<ImmutableList<Integer>> getDaysOfMonth() {
        return this.daysOfMonth;
    }

    public Optional<ImmutableList<Integer>> getDaysOfWeek() {
        return this.daysOfWeek;
    }

    public static DateTime withDayOfAbsoluteWeek(DateTime datetime, int dayOfWeek) {
        int weekOfYear = datetime.get(Joda.AbsWeekOfYear);
        int firstDayOfWeek = datetime.withDayOfYear((weekOfYear - 1) * 7 + 1).getDayOfWeek();
        int dayOfWeekOffset = (7 - firstDayOfWeek + dayOfWeek) % 7;
        return datetime.withDayOfYear((weekOfYear - 1) * 7 + 1 + dayOfWeekOffset);
    }

    public static DateTime withFirstDayOfAbsoluteWeek(DateTime datetime) {
        int weekOfYear = datetime.get(Joda.AbsWeekOfYear);
        return datetime.withDayOfYear((weekOfYear - 1) * 7 + 1);
    }

    public static DateTime withDayOfAbsoluteWeekOfMonth(DateTime datetime, int dayOfWeek) {
        int weekOfMonth = datetime.get(Joda.AbsWeekOfMonth);
        int firstDayOfWeek = datetime.withDayOfMonth(1).getDayOfWeek();
        int dayOfWeekOffset = (7 - firstDayOfWeek + dayOfWeek) % 7;
        return datetime.withDayOfMonth((weekOfMonth - 1) * 7 + 1 + dayOfWeekOffset);
    }

    @Override
    public Iterator<Interval> iterator() {
        return new ScheduleIterator(this);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("start", this.start).add("end", this.end.orNull()).add("duration", (Object)this.getDuration()).add("monthsOfYear", this.getMonthsOfYear()).add("weeksOfYear", this.getWeeksOfYear()).add("weeksOfMonth", this.getWeeksOfMonth()).add("daysOfYear", this.getDaysOfYear()).add("daysOfMonth", this.getDaysOfMonth()).add("daysOfWeek", this.getDaysOfWeek()).omitNullValues().toString();
    }

    public boolean equals(Object that) {
        return that instanceof Schedule && this.compareTo((Schedule)that) == 0;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.start, this.end, this.getDuration(), this.getMonthsOfYear(), this.getWeeksOfYear(), this.getWeeksOfMonth(), this.getDaysOfYear(), this.getDaysOfMonth(), this.getDaysOfWeek()});
    }

    @Override
    public int compareTo(Schedule<T> that) {
        return ComparisonChain.start().compare(this.start, that.start).compare(this.end.orNull(), that.end.orNull(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)this.getDuration(), (Object)that.getDuration(), (Comparator)PeriodOrdering.INSTANCE.nullsFirst()).compare(this.getMonthsOfYear().orNull(), that.getMonthsOfYear().orNull(), (Comparator)Ordering.natural().lexicographical().nullsFirst()).compare(this.getWeeksOfYear().orNull(), that.getWeeksOfYear().orNull(), (Comparator)Ordering.natural().lexicographical().nullsFirst()).compare(this.getWeeksOfMonth().orNull(), that.getWeeksOfMonth().orNull(), (Comparator)Ordering.natural().lexicographical().nullsFirst()).compare(this.getDaysOfYear().orNull(), that.getDaysOfYear().orNull(), (Comparator)Ordering.natural().lexicographical().nullsFirst()).compare(this.getDaysOfMonth().orNull(), that.getDaysOfMonth().orNull(), (Comparator)Ordering.natural().lexicographical().nullsFirst()).compare(this.getDaysOfWeek().orNull(), that.getDaysOfWeek().orNull(), (Comparator)Ordering.natural().lexicographical().nullsFirst()).result();
    }

    public static class Builder<T extends BaseDateTime> {
        private transient T start;
        private transient T end;
        private transient Period duration;
        private transient List<Alteration<T>> alterations;
        private transient List<Integer> monthsOfYear;
        private transient List<Integer> weeksOfYear;
        private transient List<Integer> weeksOfMonth;
        private transient List<Integer> daysOfYear;
        private transient List<Integer> daysOfMonth;
        private transient List<Integer> daysOfWeek;

        public Builder() {
        }

        public Builder(Schedule<T> prior) {
            this.start = ((Schedule)prior).start;
            this.end = (BaseDateTime)((Schedule)prior).end.orNull();
            this.duration = prior.getDuration();
            this.alterations = (List)prior.getAlterations().orNull();
            this.monthsOfYear = (List)prior.getMonthsOfYear().orNull();
            this.weeksOfYear = (List)prior.getWeeksOfYear().orNull();
            this.weeksOfMonth = (List)prior.getWeeksOfMonth().orNull();
            this.daysOfYear = (List)prior.getDaysOfYear().orNull();
            this.daysOfMonth = (List)prior.getDaysOfMonth().orNull();
            this.daysOfWeek = (List)prior.getDaysOfWeek().orNull();
        }

        public Builder<T> start(T start) {
            this.start = start;
            return this;
        }

        public Builder<T> end(T end) {
            this.end = end;
            return this;
        }

        public Builder<T> duration(Period duration) {
            this.duration = duration;
            return this;
        }

        public Builder<T> monthsOfYear(Integer firstMonthOfYear, Integer ... subsequentMonthsOfYear) {
            this.monthsOfYear = ImmutableList.copyOf((Collection)Lists.asList((Object)firstMonthOfYear, (Object[])subsequentMonthsOfYear));
            return this;
        }

        public Builder<T> monthsOfYear(List<Integer> monthsOfYear) {
            this.monthsOfYear = monthsOfYear == null ? null : ImmutableList.copyOf(monthsOfYear);
            return this;
        }

        public Builder<T> weeksOfYear(Integer firstWeekOfYear, Integer ... subsequentWeeksOfYear) {
            this.weeksOfYear = ImmutableList.copyOf((Collection)Lists.asList((Object)firstWeekOfYear, (Object[])subsequentWeeksOfYear));
            return this;
        }

        public Builder<T> weeksOfYear(List<Integer> weeksOfYear) {
            this.weeksOfYear = weeksOfYear == null ? null : ImmutableList.copyOf(weeksOfYear);
            return this;
        }

        public Builder<T> alterations(List<Alteration<T>> alterations) {
            this.alterations = alterations;
            return this;
        }

        public Builder<T> weeksOfMonth(Integer firstWeekOfMonth, Integer ... subsequentWeeksOfMonth) {
            this.weeksOfMonth = ImmutableList.copyOf((Collection)Lists.asList((Object)firstWeekOfMonth, (Object[])subsequentWeeksOfMonth));
            return this;
        }

        public Builder<T> weeksOfMonth(List<Integer> weeksOfMonth) {
            this.weeksOfMonth = weeksOfMonth == null ? null : ImmutableList.copyOf(weeksOfMonth);
            return this;
        }

        public Builder<T> daysOfYear(Integer firstDayOfYear, Integer ... subsequentDaysOfYear) {
            this.daysOfYear = ImmutableList.copyOf((Collection)Lists.asList((Object)firstDayOfYear, (Object[])subsequentDaysOfYear));
            return this;
        }

        public Builder<T> daysOfYear(List<Integer> daysOfYear) {
            this.daysOfYear = daysOfYear == null ? null : ImmutableList.copyOf(daysOfYear);
            return this;
        }

        public Builder<T> daysOfMonth(Integer firstDayOfMonth, Integer ... subsequentDaysOfMonth) {
            this.daysOfMonth = ImmutableList.copyOf((Collection)Lists.asList((Object)firstDayOfMonth, (Object[])subsequentDaysOfMonth));
            return this;
        }

        public Builder<T> daysOfMonth(List<Integer> daysOfMonth) {
            this.daysOfMonth = daysOfMonth == null ? null : ImmutableList.copyOf(daysOfMonth);
            return this;
        }

        public Builder<T> daysOfWeek(Integer firstDayOfWeek, Integer ... subsequentDaysOfWeek) {
            this.daysOfWeek = ImmutableList.copyOf((Collection)Lists.asList((Object)firstDayOfWeek, (Object[])subsequentDaysOfWeek));
            return this;
        }

        public Builder<T> daysOfWeek(List<Integer> daysOfWeek) {
            this.daysOfWeek = daysOfWeek == null ? null : ImmutableList.copyOf(daysOfWeek);
            return this;
        }

        public Schedule<T> build() {
            return new Schedule<T>(this.start, this.end, this.duration, this.alterations, this.monthsOfYear, this.weeksOfYear, this.weeksOfMonth, this.daysOfYear, this.daysOfMonth, this.daysOfWeek);
        }
    }
}

