/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.schedule;

import com.google.common.collect.ImmutableList;
import com.wealdtech.ServerError;
import com.wealdtech.schedule.Alteration;
import com.wealdtech.schedule.Schedule;
import com.wealdtech.utils.Joda;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.BaseDateTime;

public class ScheduleIterator<T extends BaseDateTime>
implements Iterator<Interval> {
    private final transient Schedule<T> schedule;
    private transient DateTime mark;
    private transient boolean preset = false;
    private transient Integer curMonthsOfYearIndex;
    private transient Integer curWeeksOfYearIndex;
    private transient Integer curWeeksOfMonthIndex;
    private transient Integer curDaysOfYearIndex;
    private transient Integer curDaysOfMonthIndex;
    private transient Integer curDaysOfWeekIndex;
    private Iterator<Alteration<T>> alterationItr;
    private Alteration<T> alteration;

    public ScheduleIterator(Schedule<T> schedule) {
        this(schedule, schedule.getStart().toDateTime());
    }

    public ScheduleIterator(Schedule<T> schedule, DateTime mark) {
        this.schedule = schedule;
        this.mark = mark;
        if (this.schedule.getAlterations().isPresent()) {
            this.alterationItr = ((ImmutableList)this.schedule.getAlterations().get()).iterator();
            this.alteration = this.alterationItr.next();
        } else {
            this.alterationItr = null;
            this.alteration = null;
        }
        this.resetIndices();
    }

    private void resetIndices() {
        if (this.schedule.getMonthsOfYear().isPresent()) {
            this.curMonthsOfYearIndex = ((ImmutableList)this.schedule.getMonthsOfYear().get()).indexOf((Object)this.mark.getMonthOfYear());
        }
        if (this.schedule.getWeeksOfYear().isPresent()) {
            this.curWeeksOfYearIndex = ((ImmutableList)this.schedule.getWeeksOfYear().get()).indexOf((Object)this.mark.get(Joda.AbsWeekOfYear));
        }
        if (this.schedule.getWeeksOfMonth().isPresent()) {
            this.curWeeksOfMonthIndex = 0;
        }
        if (this.schedule.getDaysOfYear().isPresent()) {
            this.curDaysOfYearIndex = ((ImmutableList)this.schedule.getDaysOfYear().get()).indexOf((Object)this.mark.getDayOfYear());
        }
        if (this.schedule.getDaysOfMonth().isPresent()) {
            this.curDaysOfMonthIndex = ((ImmutableList)this.schedule.getDaysOfMonth().get()).indexOf((Object)this.mark.getDayOfMonth());
        }
        if (this.schedule.getDaysOfWeek().isPresent()) {
            this.curDaysOfWeekIndex = ((ImmutableList)this.schedule.getDaysOfWeek().get()).indexOf((Object)this.mark.getDayOfWeek());
        }
        this.preset = true;
    }

    private DateTime resetWeek(DateTime mark) {
        if (this.schedule.getWeeksOfMonth().isPresent()) {
            return this.resetWeekOfMonth(mark);
        }
        if (this.schedule.getWeeksOfYear().isPresent()) {
            return this.resetWeekOfYear(mark);
        }
        return mark;
    }

    private DateTime resetWeekOfMonth(DateTime mark) {
        this.curWeeksOfMonthIndex = 0;
        return mark.withField(Joda.AbsWeekOfMonth, ((Integer)((ImmutableList)this.schedule.getWeeksOfMonth().get()).get(0)).intValue());
    }

    private DateTime resetWeekOfYear(DateTime mark) {
        this.curWeeksOfYearIndex = 0;
        return mark.withField(Joda.AbsWeekOfYear, ((Integer)((ImmutableList)this.schedule.getWeeksOfYear().get()).get(0)).intValue());
    }

    private DateTime resetMonth(DateTime mark) {
        if (this.schedule.getMonthsOfYear().isPresent()) {
            return this.resetMonthOfYear(mark);
        }
        throw new ServerError("Mismatch for month of year component");
    }

    private DateTime resetMonthOfYear(DateTime mark) {
        this.curMonthsOfYearIndex = 0;
        return mark.withMonthOfYear(((Integer)((ImmutableList)this.schedule.getMonthsOfYear().get()).get(0)).intValue());
    }

    private DateTime resetDay(DateTime mark) {
        if (this.schedule.getDaysOfWeek().isPresent()) {
            if (this.schedule.getWeeksOfYear().isPresent()) {
                return this.resetDayOfWeek(mark);
            }
            if (this.schedule.getWeeksOfMonth().isPresent()) {
                return this.resetDayOfWeekOfMonth(mark);
            }
            throw new ServerError("Bad schedule (DoW without Wo?)");
        }
        if (this.schedule.getDaysOfMonth().isPresent()) {
            return this.resetDayOfMonth(mark);
        }
        if (this.schedule.getDaysOfYear().isPresent()) {
            return this.resetDayOfYear(mark);
        }
        throw new ServerError("Schedule without day component");
    }

    private DateTime resetDayOfWeek(DateTime mark) {
        return Schedule.withDayOfAbsoluteWeek(mark, (Integer)((ImmutableList)this.schedule.getDaysOfWeek().get()).get(this.curDaysOfWeekIndex.intValue()));
    }

    private DateTime resetDayOfWeekOfMonth(DateTime mark) {
        return Schedule.withDayOfAbsoluteWeekOfMonth(mark, (Integer)((ImmutableList)this.schedule.getDaysOfWeek().get()).get(this.curDaysOfWeekIndex.intValue()));
    }

    private DateTime resetDayOfMonth(DateTime mark) throws IllegalFieldValueException {
        return mark.withDayOfMonth(((Integer)((ImmutableList)this.schedule.getDaysOfMonth().get()).get(this.curDaysOfMonthIndex.intValue())).intValue());
    }

    private DateTime resetDayOfYear(DateTime mark) throws IllegalFieldValueException {
        return mark.withDayOfYear(((Integer)((ImmutableList)this.schedule.getDaysOfYear().get()).get(this.curDaysOfYearIndex.intValue())).intValue());
    }

    @Override
    public boolean hasNext() {
        if (this.schedule.terminates()) {
            try {
                this.next();
            }
            catch (NoSuchElementException nsee) {
                return false;
            }
            this.preset = true;
            return true;
        }
        return true;
    }

    @Override
    public Interval next() {
        Interval result = null;
        block4: while (result == null) {
            if (this.preset) {
                this.preset = false;
            } else {
                this.nextDay();
            }
            this.updateAlteration();
            if (this.alteration == null || !this.alteration.getStart().isEqual((ReadableInstant)this.mark)) {
                result = new Interval((ReadableInstant)this.mark, (ReadablePeriod)this.schedule.getDuration());
                break;
            }
            switch (this.alteration.getType()) {
                case EXCEPTION: {
                    continue block4;
                }
                case ALTERATION: {
                    result = new Interval(this.alteration.getReplacement().get());
                    continue block4;
                }
            }
            throw new ServerError("Unhandled alteration type " + (Object)((Object)this.alteration.getType()));
        }
        return result;
    }

    private void updateAlteration() {
        if (this.alteration != null) {
            while (this.alteration.getStart().isBefore((ReadableInstant)this.mark)) {
                try {
                    this.alteration = this.alterationItr.next();
                }
                catch (NoSuchElementException nsee) {
                    this.alteration = null;
                    break;
                }
            }
        }
    }

    private void nextDay() {
        if (this.schedule.getDaysOfWeek().isPresent()) {
            this.nextDayOfWeek();
        } else if (this.schedule.getDaysOfMonth().isPresent()) {
            this.nextDayOfMonth();
        } else {
            this.nextDayOfYear();
        }
        if (this.schedule.terminates() && this.mark.isAfter((ReadableInstant)this.schedule.getEnd().get())) {
            throw new NoSuchElementException("No more occurrences in this schedule");
        }
    }

    private void nextDayOfWeek() {
        ImmutableList daysOfWeek = (ImmutableList)this.schedule.getDaysOfWeek().get();
        DateTime nextMark = this.mark;
        try {
            if (this.curDaysOfWeekIndex == daysOfWeek.size() - 1) {
                this.curDaysOfWeekIndex = -1;
            }
            ScheduleIterator scheduleIterator = this;
            scheduleIterator.curDaysOfWeekIndex = scheduleIterator.curDaysOfWeekIndex + 1;
            DateTime tmp = nextMark.withDayOfWeek(((Integer)daysOfWeek.get(scheduleIterator.curDaysOfWeekIndex.intValue())).intValue());
            nextMark = tmp.equals((Object)nextMark) || tmp.isBefore((ReadableInstant)nextMark) ? tmp.plusWeeks(1) : tmp;
            if (this.curWeeksOfYearIndex != null && this.mark.get(Joda.AbsWeekOfYear) != nextMark.get(Joda.AbsWeekOfYear) || this.curWeeksOfMonthIndex != null && this.mark.get(Joda.AbsWeekOfMonth) != nextMark.get(Joda.AbsWeekOfMonth)) {
                throw new IllegalFieldValueException(DateTimeFieldType.dayOfWeek(), null, null);
            }
        }
        catch (IllegalFieldValueException ifve) {
            this.resetDaysOfWeekIndex(nextMark);
            if (this.schedule.getWeeksOfMonth().isPresent()) {
                nextMark = this.nextWeekOfMonth(this.mark);
                nextMark = this.resetDay(nextMark);
            }
            if (this.schedule.getWeeksOfYear().isPresent()) {
                nextMark = this.nextWeekOfYear(this.mark);
                nextMark = this.resetDay(nextMark);
            }
            throw new ServerError("Invalid schedule format (DoW but no Wo?)");
        }
        this.mark = nextMark;
    }

    private void resetDaysOfWeekIndex(DateTime datetime) {
        if (this.curDaysOfWeekIndex != null) {
            int weekOfYear = datetime.get(Joda.AbsWeekOfYear);
            int firstDayOfWeek = datetime.withDayOfYear((weekOfYear - 1) * 7 + 1).getDayOfWeek();
            do {
                this.curDaysOfWeekIndex = ((ImmutableList)this.schedule.getDaysOfWeek().get()).indexOf((Object)firstDayOfWeek++);
                if (firstDayOfWeek != 8) continue;
                firstDayOfWeek = 1;
            } while (this.curDaysOfWeekIndex == -1);
        }
    }

    private DateTime nextWeekOfMonth(DateTime mark) {
        ImmutableList weeksOfMonth = (ImmutableList)this.schedule.getWeeksOfMonth().get();
        DateTime nextMark = mark;
        while (true) {
            try {
                if (this.curWeeksOfMonthIndex == weeksOfMonth.size() - 1) {
                    throw new IllegalFieldValueException(DateTimeFieldType.monthOfYear(), null, null);
                }
                ScheduleIterator scheduleIterator = this;
                Integer n = scheduleIterator.curWeeksOfMonthIndex;
                Integer n2 = scheduleIterator.curWeeksOfMonthIndex = Integer.valueOf(scheduleIterator.curWeeksOfMonthIndex + 1);
                int weeksToAdd = (Integer)weeksOfMonth.get(this.curWeeksOfMonthIndex + 1) - (Integer)weeksOfMonth.get(n.intValue());
                nextMark = nextMark.plusWeeks(weeksToAdd);
                if (this.mark.getMonthOfYear() != nextMark.getMonthOfYear()) {
                    throw new IllegalFieldValueException(DateTimeFieldType.monthOfYear(), null, null);
                }
            }
            catch (IllegalFieldValueException ifve) {
                try {
                    this.curWeeksOfMonthIndex = 0;
                    nextMark = this.nextMonthOfYear(this.mark);
                    nextMark = this.resetDay(nextMark);
                    nextMark = this.resetWeek(nextMark);
                }
                catch (IllegalFieldValueException ifve2) {
                    continue;
                }
            }
            break;
        }
        return nextMark;
    }

    private DateTime nextWeekOfYear(DateTime mark) {
        ImmutableList weeksOfYear = (ImmutableList)this.schedule.getWeeksOfYear().get();
        DateTime nextMark = Schedule.withFirstDayOfAbsoluteWeek(mark);
        block6: while (true) {
            try {
                while (true) {
                    if (this.curWeeksOfYearIndex == weeksOfYear.size() - 1) {
                        throw new IllegalFieldValueException(DateTimeFieldType.weekOfWeekyear(), null, null);
                    }
                    ScheduleIterator scheduleIterator = this;
                    scheduleIterator.curWeeksOfYearIndex = scheduleIterator.curWeeksOfYearIndex + 1;
                    DateTime tmp = nextMark.withField(Joda.AbsWeekOfYear, ((Integer)weeksOfYear.get(scheduleIterator.curWeeksOfYearIndex.intValue())).intValue());
                    try {
                        nextMark = this.resetDay(tmp);
                        break block6;
                    }
                    catch (IllegalFieldValueException ifve) {
                        continue;
                    }
                    break;
                }
            }
            catch (IllegalFieldValueException ifve) {
                try {
                    nextMark = this.nextYear(nextMark);
                    nextMark = this.resetDay(nextMark);
                    nextMark = this.resetWeek(nextMark);
                }
                catch (IllegalFieldValueException ifve2) {
                    continue;
                }
            }
            break;
        }
        return nextMark;
    }

    private void nextDayOfMonth() {
        ImmutableList daysOfMonth = (ImmutableList)this.schedule.getDaysOfMonth().get();
        DateTime nextMark = this.mark;
        try {
            if (this.curDaysOfMonthIndex == daysOfMonth.size() - 1) {
                throw new IllegalFieldValueException(DateTimeFieldType.dayOfMonth(), null, null);
            }
            ScheduleIterator scheduleIterator = this;
            scheduleIterator.curDaysOfMonthIndex = scheduleIterator.curDaysOfMonthIndex + 1;
            nextMark = nextMark.withDayOfMonth(((Integer)daysOfMonth.get(scheduleIterator.curDaysOfMonthIndex.intValue())).intValue());
        }
        catch (IllegalFieldValueException ifve) {
            this.curDaysOfMonthIndex = 0;
            nextMark = this.nextMonthOfYear(this.mark);
        }
        this.mark = nextMark;
    }

    private void nextDayOfYear() {
        ImmutableList daysOfYear = (ImmutableList)this.schedule.getDaysOfYear().get();
        DateTime nextMark = this.mark;
        while (true) {
            try {
                if (this.curDaysOfYearIndex == daysOfYear.size() - 1) {
                    throw new IllegalFieldValueException(DateTimeFieldType.dayOfYear(), null, null);
                }
                ScheduleIterator scheduleIterator = this;
                scheduleIterator.curDaysOfYearIndex = scheduleIterator.curDaysOfYearIndex + 1;
                nextMark = nextMark.withDayOfYear(((Integer)daysOfYear.get(scheduleIterator.curDaysOfYearIndex.intValue())).intValue());
            }
            catch (IllegalFieldValueException ifve) {
                try {
                    this.curDaysOfYearIndex = 0;
                    nextMark = this.nextYear(nextMark);
                    nextMark = this.resetDay(nextMark);
                }
                catch (IllegalFieldValueException ifve2) {
                    continue;
                }
            }
            break;
        }
        this.mark = nextMark;
    }

    private DateTime nextMonthOfYear(DateTime mark) {
        ImmutableList monthsOfYear = (ImmutableList)this.schedule.getMonthsOfYear().get();
        DateTime nextMark = mark.withDayOfMonth(1);
        block6: while (true) {
            try {
                while (true) {
                    if (this.curMonthsOfYearIndex == monthsOfYear.size() - 1) {
                        throw new IllegalFieldValueException(DateTimeFieldType.monthOfYear(), null, null);
                    }
                    ScheduleIterator scheduleIterator = this;
                    scheduleIterator.curMonthsOfYearIndex = scheduleIterator.curMonthsOfYearIndex + 1;
                    DateTime tmp = nextMark.withMonthOfYear(((Integer)monthsOfYear.get(scheduleIterator.curMonthsOfYearIndex.intValue())).intValue());
                    try {
                        nextMark = this.resetDay(tmp);
                        nextMark = this.resetWeek(nextMark);
                        break block6;
                    }
                    catch (IllegalFieldValueException ifve) {
                        continue;
                    }
                    break;
                }
            }
            catch (IllegalFieldValueException ifve) {
                try {
                    nextMark = this.nextYear(nextMark);
                    nextMark = this.resetMonth(nextMark);
                    nextMark = this.resetWeek(nextMark);
                    nextMark = this.resetDay(nextMark);
                }
                catch (IllegalFieldValueException ifve2) {
                    continue;
                }
            }
            break;
        }
        return nextMark;
    }

    private DateTime nextYear(DateTime mark) {
        DateTime nextMark = mark;
        nextMark = nextMark.withDayOfMonth(1).withMonthOfYear(1).plusYears(1);
        return nextMark;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Schedule iterators are read-only");
    }
}

