/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.utils;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.wealdtech.Preconditions;
import com.wealdtech.configuration.Configuration;

public class CacheConfiguration
implements Configuration {
    private int maxEntries = 10000;
    private int maxDuration = 120;

    @Inject
    public CacheConfiguration() {
    }

    @JsonCreator
    private CacheConfiguration(@JsonProperty(value="maxentries") Integer maxEntries, @JsonProperty(value="maxduration") Integer maxDuration) {
        this.maxEntries = (Integer)Objects.firstNonNull((Object)maxEntries, (Object)this.maxEntries);
        this.maxDuration = (Integer)Objects.firstNonNull((Object)maxDuration, (Object)this.maxDuration);
        this.validate();
    }

    private void validate() {
        Preconditions.checkNotNull(this.maxEntries, "Maximum size is required");
        Preconditions.checkState(this.maxEntries >= 0 && this.maxEntries <= 1000000, "Maximum size must be between 0 and 1,000,000");
        Preconditions.checkNotNull(this.maxDuration, "Maximum size is required");
        Preconditions.checkState(this.maxDuration >= 0 && this.maxDuration <= 86400, "Maximum duration must be between 0 and 86,400");
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public int getMaxDuration() {
        return this.maxDuration;
    }

    public static class Builder {
        private Integer maxEntries;
        private Integer maxDuration;

        public Builder() {
        }

        public Builder(CacheConfiguration prior) {
            this.maxEntries = prior.maxEntries;
            this.maxDuration = prior.maxDuration;
        }

        public Builder maxEntries(Integer maxEntries) {
            this.maxEntries = maxEntries;
            return this;
        }

        public Builder maxDuration(Integer maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        public CacheConfiguration build() {
            return new CacheConfiguration(this.maxEntries, this.maxDuration);
        }
    }
}

