/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.utils;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.wealdtech.Preconditions;
import com.wealdtech.TwoTuple;
import com.wealdtech.utils.HashConfiguration;
import com.wealdtech.utils.WealdMetrics;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.mindrot.jbcrypt.BCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Hash {
    INSTANCE;

    private static final Logger LOGGER;
    private static final LoadingCache<TwoTuple<String, String>, Boolean> CACHE;
    private static final Meter LOOKUPS;
    private static final Meter MISSES;
    private static final Timer GETS;
    private static final HashConfiguration CONFIGURATION;

    public static String hash(String input) {
        Preconditions.checkNotNull(input, "Cannot hash NULL");
        return BCrypt.hashpw((String)input, (String)BCrypt.gensalt((int)CONFIGURATION.getStrength()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean matches(String input, String hashed) {
        Preconditions.checkNotNull(hashed, "Cannot compare NULL");
        LOOKUPS.mark();
        Timer.Context context = GETS.time();
        try {
            boolean result = false;
            try {
                result = (Boolean)CACHE.get(new TwoTuple<String, String>(input, hashed));
            }
            catch (ExecutionException e) {
                LOGGER.error("Failed to hash input password", (Throwable)e);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            context.stop();
        }
    }

    private static boolean calculateMatches(String input, String hashed) {
        Boolean result = false;
        try {
            result = BCrypt.checkpw((String)input, (String)hashed);
        }
        catch (IllegalArgumentException iae) {
            LOGGER.error("Failed to calculate hash for input password", (Throwable)iae);
        }
        return result;
    }

    public static boolean isHashed(String input) {
        Preconditions.checkNotNull(input, "Cannot consider NULL");
        boolean hashed = input.startsWith("$2a$") || input.startsWith("$2$");
        return hashed;
    }

    static {
        LOGGER = LoggerFactory.getLogger(Hash.class);
        CONFIGURATION = new HashConfiguration();
        LOOKUPS = WealdMetrics.defaultRegistry().meter(MetricRegistry.name(Hash.class, (String[])new String[]{"lookups"}));
        MISSES = WealdMetrics.defaultRegistry().meter(MetricRegistry.name(Hash.class, (String[])new String[]{"misses"}));
        GETS = WealdMetrics.defaultRegistry().timer(MetricRegistry.name(Hash.class, (String[])new String[]{"gets"}));
        CacheBuilder cb = CacheBuilder.newBuilder().maximumSize((long)CONFIGURATION.getCacheConfiguration().getMaxEntries()).expireAfterWrite((long)CONFIGURATION.getCacheConfiguration().getMaxDuration(), TimeUnit.SECONDS);
        CACHE = cb.recordStats().build((CacheLoader)new CacheLoader<TwoTuple<String, String>, Boolean>(){

            public Boolean load(TwoTuple<String, String> input) {
                MISSES.mark();
                return Hash.calculateMatches(input.getS(), input.getT());
            }
        });
    }
}

