/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.utils;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.wealdtech.Preconditions;
import com.wealdtech.configuration.Configuration;
import com.wealdtech.utils.CacheConfiguration;

public class HashConfiguration
implements Configuration {
    private CacheConfiguration cacheConfiguration = new CacheConfiguration();
    private int strength = 12;

    @Inject
    public HashConfiguration() {
    }

    @JsonCreator
    private HashConfiguration(@JsonProperty(value="cache") CacheConfiguration cacheConfiguration, @JsonProperty(value="strength") Integer strength) {
        this.cacheConfiguration = (CacheConfiguration)Objects.firstNonNull((Object)cacheConfiguration, (Object)this.cacheConfiguration);
        this.strength = (Integer)Objects.firstNonNull((Object)strength, (Object)this.strength);
        this.validate();
    }

    private void validate() {
        Preconditions.checkNotNull(this.cacheConfiguration, "Cache configuration is required");
        Preconditions.checkNotNull(this.strength, "Strength is required");
        Preconditions.checkState(this.strength >= 4 && this.strength <= 20, "Strength must be between 4 and 20");
    }

    public CacheConfiguration getCacheConfiguration() {
        return this.cacheConfiguration;
    }

    public int getStrength() {
        return this.strength;
    }

    public static class Builder {
        private CacheConfiguration cacheConfiguration;
        private Integer strength;

        public Builder() {
        }

        public Builder(HashConfiguration prior) {
            this.cacheConfiguration = prior.cacheConfiguration;
            this.strength = prior.strength;
        }

        public Builder cacheConfiguration(CacheConfiguration cacheConfiguration) {
            this.cacheConfiguration = cacheConfiguration;
            return this;
        }

        public Builder strength(Integer strength) {
            this.strength = strength;
            return this;
        }

        public HashConfiguration build() {
            return new HashConfiguration(this.cacheConfiguration, this.strength);
        }
    }
}

