/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.utils.messaging;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.wealdtech.DataError;
import com.wealdtech.Preconditions;
import com.wealdtech.utils.StringUtils;
import com.wealdtech.utils.messaging.MessageObjects;
import java.util.Locale;

public class MessageItem {
    private final transient Type msgtype;
    private final transient String destination;
    private final transient MessageObjects<?> objects;

    public MessageItem(Type msgtype, String destination, MessageObjects<?> objects) {
        this.msgtype = msgtype;
        this.destination = destination;
        this.objects = objects;
    }

    public Type getMsgType() {
        return this.msgtype;
    }

    public String getDestination() {
        return this.destination;
    }

    public MessageObjects<?> getObjects() {
        return this.objects;
    }

    public static enum Type {
        PUBLISH,
        QUEUE;


        @JsonValue
        public String toString() {
            return StringUtils.capitalize(super.toString().toLowerCase(Locale.ENGLISH));
        }

        @JsonCreator
        public static Type fromString(String type) {
            Preconditions.checkNotNull(type, "Message item type is required");
            try {
                return Type.valueOf(type.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException iae) {
                throw new DataError.Bad("A message item type supplied is invalid");
            }
        }
    }
}

