/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.primitives.Longs;
import com.wealdtech.DataError;
import com.wealdtech.Preconditions;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nonnull;

public class WID<T>
implements Comparable<WID<T>>,
Serializable {
    private static final Random RANDOM = new Random();
    private static final long serialVersionUID = 6897379549693105270L;
    private static final String WID_SEPARATOR = ".";
    public static final long EPOCH = 1325376000000L;
    private static final long TIMESTAMPMASK = -8388608L;
    private static final int TIMESTAMPOFFSET = 22;
    private static final int TIMESTAMPSIZE = 41;
    public static final long MAX_TIMESTAMP = 0x1FFFFFFFFFFL;
    private static final long SHARDMASK = 8380416L;
    private static final int SHARDOFFSET = 10;
    private static final int SHARDSIZE = 12;
    public static final long MAX_SHARD = 4095L;
    private static final long IIDMASK = 1023L;
    private static final int IIDSIZE = 10;
    public static final long MAX_IID = 1023L;
    private static final int RADIX = 16;
    private final long id;
    private final Optional<Long> subId;

    public WID(long id) {
        this(id, null);
    }

    public WID(long id, Long subId) {
        this.id = id;
        this.subId = Optional.fromNullable((Object)subId);
    }

    @JsonIgnore
    public long getShardId() {
        return (this.id & 0x7FE000L) >> 10;
    }

    @JsonIgnore
    public long getTimestamp() {
        return ((this.id & 0xFFFFFFFFFF800000L) >> 22) + 1325376000000L;
    }

    @JsonIgnore
    public long getIid() {
        return this.id & 0x3FFL;
    }

    @JsonIgnore
    public long getId() {
        return this.id;
    }

    @JsonIgnore
    public Optional<Long> getSubId() {
        return this.subId;
    }

    @JsonIgnore
    public boolean hasSubId() {
        return this.subId.isPresent();
    }

    @JsonCreator
    public static <T> WID<T> fromString(String input) {
        Preconditions.checkNotNull(input, "Passed NULL WID");
        if (input.contains(WID_SEPARATOR)) {
            Iterator ids = Splitter.on((String)WID_SEPARATOR).split((CharSequence)input).iterator();
            try {
                return new WID<T>(Long.valueOf((String)ids.next(), 16), Long.valueOf((String)ids.next(), 16));
            }
            catch (NumberFormatException nfe) {
                throw new DataError.Bad("Failed to parse WID \"" + input + "\"", nfe);
            }
        }
        try {
            return new WID<T>(Long.valueOf(input, 16));
        }
        catch (NumberFormatException nfe) {
            throw new DataError.Bad("Failed to parse WID \"" + input + "\"", nfe);
        }
    }

    public static <T> WID<T> fromComponents(long shardId, long timestamp, long id) {
        return WID.fromComponents(shardId, timestamp, id, null);
    }

    public static <T> WID<T> fromComponents(long shardId, long timestamp, long id, Long subId) {
        long adjustedTimestamp = timestamp - 1325376000000L;
        Preconditions.checkArgument(shardId >= 0L && shardId < 4095L, "Shard ID %s out of range %s", shardId);
        Preconditions.checkArgument(timestamp >= 1325376000000L && adjustedTimestamp < 0x1FFFFFFFFFFL, "Timestamp %s out of range %s", timestamp, 0x1FFFFFFFFFFL);
        Preconditions.checkArgument(id >= 0L && id < 1023L, "ID %s out of range", id);
        return new WID<T>(shardId << 10 & 0x7FE000L | adjustedTimestamp << 22 & 0xFFFFFFFFFF800000L | id & 0x3FFL, subId);
    }

    public static <T> WID<T> fromLong(Long id) {
        Preconditions.checkNotNull(id, "Passed NULL WID");
        return new WID<T>(id, null);
    }

    public static <T> WID<T> fromLongs(Long id, Long subId) {
        Preconditions.checkNotNull(id, "Passed NULL WID");
        return new WID<T>(id, subId);
    }

    public static <T> WID<T> generate() {
        return WID.generate(RANDOM.nextInt(4095));
    }

    public static <T> WID<T> generate(int shardId) {
        long timestamp = System.currentTimeMillis();
        long id = RANDOM.nextInt(1023);
        return WID.fromComponents(shardId, timestamp, id);
    }

    public WID<T> withSubId(Long subId) {
        return new WID<T>(this.getId(), subId);
    }

    public static <T> WID<T> recast(WID<?> wid) {
        return wid;
    }

    @JsonValue
    public String toString() {
        if (this.hasSubId()) {
            return Long.toHexString(this.id) + WID_SEPARATOR + Long.toHexString((Long)this.subId.get());
        }
        return Long.toHexString(this.id);
    }

    public int hashCode() {
        if (this.hasSubId()) {
            return Objects.hashCode((Object[])new Object[]{this.id, this.subId.get()});
        }
        return Longs.hashCode((long)this.id);
    }

    public boolean equals(Object that) {
        if (!(that instanceof WID)) {
            return false;
        }
        WID cThat = (WID)that;
        return this.id == cThat.id && this.getSubId().equals(cThat.getSubId());
    }

    @Override
    public int compareTo(@Nonnull WID<T> that) {
        if (this.id > that.id) {
            return 1;
        }
        if (this.id < that.id) {
            return -1;
        }
        if (this.hasSubId() && !that.hasSubId()) {
            return 1;
        }
        if (!this.hasSubId() && that.hasSubId()) {
            return -1;
        }
        if (!this.hasSubId() && !that.hasSubId()) {
            return 0;
        }
        return ((Long)this.getSubId().get()).compareTo((Long)that.getSubId().get());
    }
}

