/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.collect;

import com.google.common.base.Objects;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import com.wealdtech.ServerError;
import com.wealdtech.TwoTuple;
import com.wealdtech.collect.RangedMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class TreeRangedMap<K extends Comparable<K>, V>
implements RangedMap<K, V> {
    private final TreeMap<K, TwoTuple<Range<K>, V>> underlying = new TreeMap();

    @Override
    @Nullable
    public V get(K key) {
        Map.Entry<K, TwoTuple<Range<K>, V>> floorEntry = this.underlying.floorEntry(key);
        if (floorEntry != null && floorEntry.getValue().getS().contains(key)) {
            return floorEntry.getValue().getT();
        }
        return null;
    }

    @Override
    public List<TwoTuple<Range<K>, V>> get(Range<K> range) {
        throw new ServerError("Not implemented");
    }

    @Override
    @Nullable
    public Map.Entry<K, TwoTuple<Range<K>, V>> getEntry(K key) {
        Map.Entry<K, TwoTuple<Range<K>, V>> entry = this.underlying.floorEntry(key);
        if (entry != null && entry.getValue().getS().contains(key)) {
            return entry;
        }
        return null;
    }

    @Override
    public int size() {
        return this.underlying.size();
    }

    private void validateRange(Range<K> range) {
        if (!range.hasLowerBound()) {
            throw new IllegalArgumentException("RangedMap only supports ranges with defined lower bound");
        }
        if (!range.lowerBoundType().equals((Object)BoundType.CLOSED)) {
            throw new IllegalArgumentException("RangedMap must use ranges with closed lower bound");
        }
        if (!range.hasUpperBound()) {
            throw new IllegalArgumentException("RangedMap must use ranges with defined upper bound");
        }
        if (!range.upperBoundType().equals((Object)BoundType.OPEN)) {
            throw new IllegalArgumentException("RangedMap must use ranges with open upper bound");
        }
        if (range.isEmpty()) {
            throw new IllegalArgumentException("RangedMap must use ranges with non-zero size");
        }
    }

    @Override
    public void put(Range<K> key, V value) {
        this.validateRange(key);
        Comparable resultantStart = key.lowerEndpoint();
        Comparable resultantEnd = key.upperEndpoint();
        Map.Entry<Comparable, TwoTuple<Range<Comparable>, V>> prior = this.getEntry(key.lowerEndpoint());
        if (prior != null) {
            if (prior.getValue().getT().equals(value)) {
                if (resultantEnd.compareTo(prior.getValue().getS().upperEndpoint()) < 0) {
                    return;
                }
                this.underlying.remove(prior.getKey());
                resultantStart = prior.getKey();
            } else {
                this.underlying.put(prior.getKey(), new TwoTuple<Range, V>(Range.closedOpen((Comparable)prior.getKey(), (Comparable)resultantStart), prior.getValue().getT()));
                if (resultantEnd.compareTo(prior.getValue().getS().upperEndpoint()) < 0) {
                    this.underlying.put(resultantEnd, new TwoTuple<Range, V>(Range.closedOpen((Comparable)resultantEnd, (Comparable)prior.getValue().getS().upperEndpoint()), prior.getValue().getT()));
                }
            }
        }
        Map.Entry<Comparable, TwoTuple<Range<K>, V>> potentialVictim = this.underlying.ceilingEntry(resultantStart);
        while (potentialVictim != null) {
            if (key.encloses(potentialVictim.getValue().getS())) {
                this.underlying.remove(potentialVictim.getKey());
                potentialVictim = this.underlying.ceilingEntry(resultantStart);
                continue;
            }
            if (key.contains(potentialVictim.getKey())) {
                if (potentialVictim.getValue().getT().equals(value)) {
                    resultantEnd = potentialVictim.getValue().getS().upperEndpoint();
                    this.underlying.remove(potentialVictim.getKey());
                } else {
                    this.underlying.remove(potentialVictim.getKey());
                    this.underlying.put(resultantEnd, new TwoTuple<Range, V>(Range.closedOpen((Comparable)resultantEnd, (Comparable)potentialVictim.getValue().getS().upperEndpoint()), potentialVictim.getValue().getT()));
                }
                potentialVictim = null;
                continue;
            }
            potentialVictim = null;
        }
        this.underlying.put(resultantStart, new TwoTuple<Range, V>(Range.closedOpen((Comparable)resultantStart, (Comparable)resultantEnd), value));
    }

    @Nullable
    private K findFloor(Range<K> key) {
        Map.Entry<Comparable, TwoTuple<Range<K>, V>> floorEntry = this.underlying.floorEntry(key.lowerEndpoint());
        Comparable lowerEndpoint = floorEntry != null && floorEntry.getValue().getS().upperEndpoint().compareTo(key.lowerEndpoint()) > 0 ? floorEntry.getKey() : key.lowerEndpoint();
        return (K)lowerEndpoint;
    }

    @Override
    public void putAll(RangedMap<K, V> rangedMap) {
        throw new ServerError("Not implemented");
    }

    @Override
    public void clear() {
        throw new ServerError("Not implemented");
    }

    @Override
    public void remove(K key) {
        throw new ServerError("Not implemented");
    }

    @Override
    public void remove(Range<K> range) {
        throw new ServerError("Not implemented");
    }

    public String toString() {
        Objects.ToStringHelper sh = Objects.toStringHelper((Object)this);
        NavigableSet<K> ns = this.underlying.navigableKeySet();
        for (Comparable key : ns) {
            sh.addValue(this.underlying.get(key));
        }
        return sh.toString();
    }
}

