/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.collect;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.wealdtech.collect.RangedMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class TreeRangedMultimap<K extends Comparable<? super K>, V>
implements RangedMultimap<K, V> {
    private TreeMap<K, List<V>> startMap = new TreeMap();
    private TreeMap<K, List<V>> endMap = new TreeMap();
    private int size = 0;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.startMap.isEmpty();
    }

    @Override
    public boolean put(Range<K> key, V value) {
        List<V> startArray = this.startMap.get(key.lowerEndpoint());
        if (startArray == null) {
            startArray = new ArrayList<V>();
            this.startMap.put(key.lowerEndpoint(), startArray);
        }
        startArray.add(value);
        List<V> endArray = this.endMap.get(key.upperEndpoint());
        if (endArray == null) {
            endArray = new ArrayList<V>();
            this.endMap.put(key.upperEndpoint(), endArray);
        }
        endArray.add(value);
        ++this.size;
        return true;
    }

    @Override
    public Collection<V> get(Range<K> range) {
        ImmutableSet.Builder startersB = ImmutableSet.builder();
        Map.Entry<Comparable, List<V>> startEntry = this.startMap.floorEntry(range.upperEndpoint());
        while (startEntry != null) {
            if (!startEntry.getKey().equals(range.upperEndpoint())) {
                startersB.addAll((Iterable)startEntry.getValue());
            }
            startEntry = this.startMap.lowerEntry(startEntry.getKey());
        }
        ImmutableSet starters = startersB.build();
        ImmutableSet.Builder finishersB = ImmutableSet.builder();
        Map.Entry<Comparable, List<V>> finishEntry = this.endMap.ceilingEntry(range.lowerEndpoint());
        while (finishEntry != null) {
            if (!finishEntry.getKey().equals(range.lowerEndpoint())) {
                finishersB.addAll((Iterable)finishEntry.getValue());
            }
            finishEntry = this.endMap.higherEntry(finishEntry.getKey());
        }
        ImmutableSet finishers = finishersB.build();
        return Sets.intersection((Set)starters, (Set)finishers);
    }
}

