/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.utils;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.wealdtech.DataError;
import com.wealdtech.Preconditions;
import com.wealdtech.utils.StringUtils;
import java.util.Locale;

public enum EnvironmentType {
    DEVELOPMENT,
    TEST,
    TESTSTANDBY,
    PRODUCTION,
    PROUDUCTIONSTANDBY;


    @JsonValue
    public String toString() {
        return StringUtils.capitalize(super.toString().toLowerCase(Locale.ENGLISH));
    }

    @JsonCreator
    public static EnvironmentType fromString(String type) {
        Preconditions.checkNotNull(type, "Environment type is required");
        try {
            return EnvironmentType.valueOf(type.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            throw new DataError.Bad("An environment type supplied is invalid");
        }
    }
}

