/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.utils;

import com.google.common.collect.Range;
import com.wealdtech.DataError;
import java.util.Locale;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatterBuilder;

public class RangeFormatter {
    private final Locale locale;
    private Style style;

    public RangeFormatter() {
        this.locale = Locale.getDefault();
        this.style = Style.NORMAL;
    }

    public RangeFormatter(Style style) {
        this.locale = Locale.getDefault();
        this.style = style;
    }

    public RangeFormatter(Locale locale, Style style) {
        this.locale = locale;
        this.style = style;
    }

    @Nullable
    public String formatDateTime(@Nullable Range<DateTime> range) {
        if (range == null) {
            return null;
        }
        DateTime curDateTime = DateTime.now();
        StringBuilder sb = new StringBuilder(96);
        DateTime lower = (DateTime)range.lowerEndpoint();
        DateTime upper = (DateTime)range.upperEndpoint();
        if (upper.isBefore((ReadableInstant)lower)) {
            throw new DataError.Bad("Upper part of range must be after lower part of range");
        }
        Details lowerDetails = new Details();
        lowerDetails.showTime = true;
        if (!this.isSameDay(lower, curDateTime)) {
            lowerDetails.showDayOfWeek = true;
            lowerDetails.showDayOfMonth = true;
            lowerDetails.showMonthOfYear = true;
        }
        if (!this.isSameYear(lower, upper) || !this.isSameYear(lower, curDateTime)) {
            lowerDetails.showYear = true;
        }
        sb.append(this.doFormat(lower, lowerDetails));
        if (!this.isSameMinute(lower, upper)) {
            sb.append(" - ");
            Details upperDetails = new Details();
            upperDetails.showTime = true;
            if (!this.isSameDay(lower, upper)) {
                upperDetails.showDayOfWeek = true;
                upperDetails.showDayOfMonth = true;
                upperDetails.showMonthOfYear = true;
                if (!this.isSameYear(lower, upper) || !this.isSameYear(upper, curDateTime)) {
                    upperDetails.showYear = true;
                }
            }
            sb.append(this.doFormat(upper, upperDetails));
        }
        return sb.toString();
    }

    @Nullable
    public String formatDate(@Nullable Range<DateTime> range) {
        if (range == null || this.style == Style.TIME_ONLY) {
            return null;
        }
        DateTime curDateTime = DateTime.now();
        StringBuilder sb = new StringBuilder(64);
        DateTime lower = (DateTime)range.lowerEndpoint();
        DateTime upper = ((DateTime)range.upperEndpoint()).minusDays(1);
        if (upper.isBefore((ReadableInstant)lower)) {
            throw new DataError.Bad("Upper part of range must be after lower part of range");
        }
        boolean singleDay = this.isSameDay(lower, upper);
        Details lowerDetails = new Details();
        lowerDetails.showTime = false;
        lowerDetails.showDayOfWeek = true;
        lowerDetails.showDayOfMonth = true;
        if (!this.isSameMonth(lower, upper) || singleDay) {
            lowerDetails.showMonthOfYear = true;
        }
        if (!(this.isSameYear(lower, curDateTime) || !singleDay && this.isSameYear(lower, upper))) {
            lowerDetails.showYear = true;
        }
        sb.append(this.doFormat(lower, lowerDetails));
        if (!this.isSameDay(lower, upper)) {
            sb.append(" - ");
            Details upperDetails = new Details();
            upperDetails.showTime = false;
            upperDetails.showDayOfWeek = true;
            upperDetails.showDayOfMonth = true;
            upperDetails.showMonthOfYear = true;
            if (!this.isSameYear(lower, upper) || !this.isSameYear(upper, curDateTime)) {
                upperDetails.showYear = true;
            }
            sb.append(this.doFormat(upper, upperDetails));
        } else {
            if (!this.isSameMonth(lower, curDateTime)) {
                lowerDetails.showMonthOfYear = true;
            }
            if (!this.isSameYear(lower, curDateTime)) {
                lowerDetails.showYear = true;
            }
        }
        return sb.toString();
    }

    @Nullable
    public String formatDate(@Nullable DateTime dateTime) {
        return dateTime == null || this.style == Style.TIME_ONLY ? null : this.formatDateAndTime(dateTime, true, false);
    }

    @Nullable
    public String formatTime(@Nullable DateTime dateTime) {
        return dateTime == null ? null : this.formatDateAndTime(dateTime, false, true);
    }

    @Nullable
    public String formatDateTime(@Nullable DateTime dateTime) {
        return dateTime == null ? null : this.formatDateAndTime(dateTime, true, true);
    }

    private String formatDateAndTime(DateTime dateTime, boolean showDate, boolean showTime) {
        DateTime curDateTime = DateTime.now();
        Details dateDetails = new Details();
        dateDetails.showTime = showTime;
        dateDetails.showDayOfWeek = showDate;
        dateDetails.showDayOfMonth = showDate;
        dateDetails.showMonthOfYear = showDate;
        if (!this.isSameYear(dateTime, curDateTime)) {
            dateDetails.showYear = showDate;
        }
        return this.doFormat(dateTime, dateDetails);
    }

    private String doFormat(DateTime datetime, Details formatDetails) {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        boolean started = false;
        if (this.style != Style.TIME_ONLY) {
            if (formatDetails.showDayOfWeek) {
                if (this.style == Style.NORMAL) {
                    builder.appendDayOfWeekShortText();
                } else {
                    builder.appendDayOfWeekText();
                }
                started = true;
            }
            if (formatDetails.showDayOfMonth) {
                if (started) {
                    builder.appendLiteral(' ');
                }
                builder.appendDayOfMonth(1);
                started = true;
            }
            if (formatDetails.showMonthOfYear) {
                if (started) {
                    builder.appendLiteral(' ');
                }
                if (this.style == Style.NORMAL) {
                    builder.appendMonthOfYearShortText();
                } else {
                    builder.appendMonthOfYearText();
                }
                started = true;
            }
            if (formatDetails.showYear) {
                if (started) {
                    builder.appendLiteral(' ');
                }
                builder.appendYear(4, 4);
                started = true;
            }
        }
        if (formatDetails.showTime) {
            if (started) {
                builder.appendLiteral(' ');
            }
            builder.appendHourOfDay(2);
            builder.appendLiteral(':');
            builder.appendMinuteOfHour(2);
            started = true;
        }
        if (started) {
            return datetime.toString(builder.toFormatter().withLocale(this.locale));
        }
        return null;
    }

    private boolean isSameMinute(DateTime lower, DateTime upper) {
        return lower.getYear() == upper.getYear() && lower.getMonthOfYear() == upper.getMonthOfYear() && lower.getDayOfYear() == upper.getDayOfYear() && lower.getHourOfDay() == upper.getHourOfDay() && lower.getMinuteOfHour() == upper.getMinuteOfHour();
    }

    private boolean isSameHour(DateTime lower, DateTime upper) {
        return lower.getYear() == upper.getYear() && lower.getMonthOfYear() == upper.getMonthOfYear() && lower.getDayOfYear() == upper.getDayOfYear() && lower.getHourOfDay() == upper.getHourOfDay();
    }

    private boolean isSameDay(DateTime lower, DateTime upper) {
        return lower.getYear() == upper.getYear() && lower.getMonthOfYear() == upper.getMonthOfYear() && lower.getDayOfYear() == upper.getDayOfYear();
    }

    private boolean isSameMonth(DateTime lower, DateTime upper) {
        return lower.getYear() == upper.getYear() && lower.getMonthOfYear() == upper.getMonthOfYear();
    }

    private boolean isSameYear(DateTime lower, DateTime upper) {
        return lower.getYear() == upper.getYear();
    }

    private static class Details {
        public boolean showTime = false;
        public boolean showDayOfWeek = false;
        public boolean showDayOfMonth = false;
        public boolean showMonthOfYear = false;
        public boolean showYear = false;

        private Details() {
        }
    }

    public static enum Style {
        FULL,
        NORMAL,
        TIME_ONLY;

    }
}

