/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.utils;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Range;
import com.wealdtech.Preconditions;
import com.wealdtech.utils.IntervalOrdering;
import java.util.Comparator;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class WealdInterval
implements Comparable<WealdInterval> {
    private final transient DateTime start;
    private final transient DateTime end;

    @JsonCreator
    public WealdInterval(@JsonProperty(value="start") DateTime start, @JsonProperty(value="end") DateTime end) {
        this.start = start;
        this.end = end;
        this.validate();
    }

    public WealdInterval(DateTime start, Duration duration) {
        this.start = start;
        this.end = start.plus((ReadableDuration)duration);
    }

    public WealdInterval(DateTime start, Period period) {
        this.start = start;
        this.end = start.plus((ReadablePeriod)period);
    }

    public static WealdInterval fromRange(Range<DateTime> range) {
        return new WealdInterval((DateTime)range.lowerEndpoint(), (DateTime)range.upperEndpoint());
    }

    private void validate() {
        Preconditions.checkNotNull(this.start, "Start must be specified");
        Preconditions.checkNotNull(this.end, "End must be specified");
        Preconditions.checkState(!this.end.isBefore((ReadableInstant)this.start), "End cannot be before start");
    }

    public DateTime getStart() {
        return this.start;
    }

    public DateTime getEnd() {
        return this.end;
    }

    @JsonIgnore
    public Interval getInterval() {
        return new Interval((ReadableInstant)this.start, (ReadableInstant)this.end);
    }

    public Range<DateTime> toRange() {
        return Range.closedOpen((Comparable)this.start, (Comparable)this.end);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("start", (Object)this.start).add("end", (Object)this.end).toString();
    }

    public boolean equals(Object that) {
        return that instanceof WealdInterval && this.compareTo((WealdInterval)that) == 0;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.start, this.end});
    }

    @Override
    public int compareTo(WealdInterval that) {
        return ComparisonChain.start().compare((Object)this.getInterval(), (Object)that.getInterval(), (Comparator)((Object)IntervalOrdering.INSTANCE)).result();
    }
}

