/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.wealdtech.jackson.LcStrategy;
import com.wealdtech.jackson.modules.TriValModule;
import com.wealdtech.jackson.modules.WealdJodaModule;
import com.wealdtech.jackson.modules.WealdMiscModule;
import java.util.List;
import java.util.Map;

public class ObjectMapperConfiguration {
    private Optional<JsonFactory> factory = Optional.absent();
    private final List<Module> modules = Lists.newArrayList();
    private final Map<JsonParser.Feature, Boolean> parserFeatures;
    private final InjectableValues.Std injectableValues;
    private Optional<? extends PropertyNamingStrategy> propertyNamingStrategy;
    private Optional<JsonInclude.Include> serializationInclusion;

    public ObjectMapperConfiguration() {
        this.modules.add((Module)new GuavaModule());
        this.modules.add(new TriValModule());
        this.modules.add(new WealdJodaModule());
        this.modules.add(new WealdMiscModule());
        this.parserFeatures = Maps.newHashMap();
        this.parserFeatures.put(JsonParser.Feature.ALLOW_COMMENTS, true);
        this.injectableValues = new InjectableValues.Std();
        this.propertyNamingStrategy = Optional.fromNullable((Object)((Object)new LcStrategy()));
        this.serializationInclusion = Optional.fromNullable((Object)JsonInclude.Include.NON_NULL);
    }

    public void setFactory(JsonFactory factory) {
        this.factory = Optional.fromNullable((Object)factory);
    }

    public Optional<JsonFactory> getFactory() {
        return this.factory;
    }

    public void setPropertyNamingStrategy(PropertyNamingStrategy propertyNamingStrategy) {
        this.propertyNamingStrategy = Optional.fromNullable((Object)propertyNamingStrategy);
    }

    public void clearModules() {
        this.modules.clear();
    }

    public void addModule(Module module) {
        if (module != null) {
            this.modules.add(module);
        }
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public void clearParserFeatures() {
        this.parserFeatures.clear();
    }

    public void addParserFeature(JsonParser.Feature feature, Boolean value) {
        this.parserFeatures.put(feature, value);
    }

    public Map<JsonParser.Feature, Boolean> getParserFeatures() {
        return this.parserFeatures;
    }

    public void addInjectableValue(String name, Object value) {
        this.injectableValues.addValue(name, value);
    }

    public InjectableValues getInjectableValues() {
        return this.injectableValues;
    }

    public Optional<? extends PropertyNamingStrategy> getPropertyNamingStrategy() {
        return this.propertyNamingStrategy;
    }

    public void setSerializationInclusion(JsonInclude.Include serializationInclusion) {
        this.serializationInclusion = Optional.fromNullable((Object)serializationInclusion);
    }

    public Optional<JsonInclude.Include> getSerializationInclusion() {
        return this.serializationInclusion;
    }
}

