/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.wealdtech.jackson.LcStrategy;
import com.wealdtech.jackson.ObjectMapperConfiguration;
import com.wealdtech.jackson.modules.TriValModule;
import com.wealdtech.jackson.modules.WealdJodaModule;
import com.wealdtech.jackson.modules.WealdMiscModule;
import java.util.Map;

public class ObjectMapperFactory {
    private static final transient ObjectMapper DEFAULTMAPPER = new ObjectMapper();

    public ObjectMapper build(ObjectMapperConfiguration configuration) {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)configuration.getFactory().orNull());
        for (Module module : configuration.getModules()) {
            mapper.registerModule(module);
        }
        for (Map.Entry entry : configuration.getParserFeatures().entrySet()) {
            mapper.getFactory().configure((JsonParser.Feature)entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
        }
        mapper.setInjectableValues(configuration.getInjectableValues());
        if (configuration.getPropertyNamingStrategy().isPresent()) {
            mapper.setPropertyNamingStrategy((PropertyNamingStrategy)configuration.getPropertyNamingStrategy().get());
        }
        if (configuration.getSerializationInclusion().isPresent()) {
            mapper.setSerializationInclusion((JsonInclude.Include)configuration.getSerializationInclusion().get());
        }
        return mapper;
    }

    public static ObjectMapper getDefaultMapper() {
        return DEFAULTMAPPER;
    }

    static {
        DEFAULTMAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        DEFAULTMAPPER.setPropertyNamingStrategy((PropertyNamingStrategy)new LcStrategy());
        DEFAULTMAPPER.registerModule((Module)new WealdJodaModule());
        DEFAULTMAPPER.registerModule((Module)new GuavaModule());
        DEFAULTMAPPER.registerModule((Module)new TriValModule());
        DEFAULTMAPPER.registerModule((Module)new WealdMiscModule());
        InjectableValues.Std clientinject = new InjectableValues.Std().addValue("AllowPartials", (Object)Boolean.FALSE);
        DEFAULTMAPPER.setInjectableValues((InjectableValues)clientinject);
        DEFAULTMAPPER.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    }
}

