/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.wealdtech.jackson.ObjectMapperConfiguration;
import com.wealdtech.jackson.ObjectMapperFactory;

public enum WealdMapper {
    INSTANCE;

    private static final transient ObjectMapper CLIENT_MAPPER;
    private static final transient ObjectMapper SERVER_MAPPER;

    public static ObjectMapper getMapper() {
        return CLIENT_MAPPER;
    }

    public static ObjectMapper getServerMapper() {
        return SERVER_MAPPER;
    }

    static {
        ObjectMapperConfiguration clientConfiguration = new ObjectMapperConfiguration();
        clientConfiguration.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        CLIENT_MAPPER = new ObjectMapperFactory().build(clientConfiguration).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).enable(SerializationFeature.WRITE_BIGDECIMAL_AS_PLAIN);
        ObjectMapperConfiguration serverConfiguration = new ObjectMapperConfiguration();
        serverConfiguration.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        SERVER_MAPPER = new ObjectMapperFactory().build(serverConfiguration).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).enable(SerializationFeature.WRITE_BIGDECIMAL_AS_PLAIN);
    }
}

