/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jackson.modules;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeDeserializer
extends JsonDeserializer<DateTime> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateTimeDeserializer.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER_ISO = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.sssZ");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZ ZZZZ");
    private static final DateTimeFormatter DATE_TIME_FORMATTER_NO_TZ = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZ");

    public DateTime deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException {
        String txt = jp.getText();
        if (txt == null) {
            return null;
        }
        return DateTimeDeserializer.deserialize(txt);
    }

    public static DateTime deserialize(String txt) throws IOException {
        DateTime result = txt.indexOf(32) == -1 ? (txt.indexOf(46) == -1 ? DATE_TIME_FORMATTER_NO_TZ.parseDateTime(txt).withZone(DateTimeZone.UTC) : DATE_TIME_FORMATTER_ISO.parseDateTime(txt).withZone(DateTimeZone.UTC)) : DATE_TIME_FORMATTER.parseDateTime(txt);
        return result;
    }
}

