/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jackson.modules;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.google.common.base.Splitter;
import com.google.common.collect.Range;
import com.wealdtech.DataError;
import com.wealdtech.jackson.modules.DateTimeDeserializer;
import java.io.IOException;
import java.util.Iterator;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeRangeDeserializer
extends JsonDeserializer<Range<DateTime>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateTimeDeserializer.class);
    private static final String NEGATIVE_INFINITY = "-\u221e";
    private static final String POSITIVE_INFINITY = "+\u221e";
    private static final char WEALD_SPLITTER_CHAR = ',';
    private static final Splitter WEALD_SPLITTER = Splitter.on((char)',');
    private static final char GUAVA_SPLITTER_CHAR = '\u2025';
    private static final Splitter GUAVA_SPLITTER = Splitter.on((char)'\u2025');
    private Class<?> targetClass;

    public Range<DateTime> deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException {
        String txt = jp.getText();
        if (txt == null) {
            return null;
        }
        return DateTimeRangeDeserializer.deserialize(txt);
    }

    public static Range<DateTime> deserialize(String txt) throws IOException {
        DateTime upperPoint;
        boolean upperBound;
        DateTime lowerPoint;
        boolean lowerBound;
        Iterator dateTimes;
        boolean upperClosed;
        boolean lowerClosed;
        int firstDateChar;
        int txtLen = txt.length();
        if (txt.charAt(0) == '[') {
            firstDateChar = 1;
            lowerClosed = true;
        } else if (txt.charAt(0) == '(') {
            firstDateChar = 1;
            lowerClosed = false;
        } else if (txt.charAt(0) >= '0' && txt.charAt(0) <= '9') {
            firstDateChar = 0;
            lowerClosed = true;
        } else {
            throw new DataError.Bad("Unexpected first character in range \"" + txt + "\"");
        }
        if (txt.charAt(txtLen - 1) == ']') {
            upperClosed = true;
        } else if (txt.charAt(txtLen - 1) == ')') {
            upperClosed = false;
        } else if (firstDateChar == 0) {
            upperClosed = false;
        } else {
            throw new DataError.Bad("Unexpected last character in range \"" + txt + "\"");
        }
        if (txt.indexOf(44) != -1) {
            dateTimes = WEALD_SPLITTER.split((CharSequence)txt.substring(firstDateChar, txtLen - firstDateChar)).iterator();
        } else if (txt.indexOf(8229) != -1) {
            dateTimes = GUAVA_SPLITTER.split((CharSequence)txt.substring(firstDateChar, txtLen - firstDateChar)).iterator();
        } else {
            throw new DataError.Bad("Cannot find a range separator in range \"" + txt + "\"");
        }
        String start = (String)dateTimes.next();
        String end = (String)dateTimes.next();
        if (start.equals(NEGATIVE_INFINITY)) {
            lowerBound = false;
            lowerPoint = null;
        } else {
            lowerBound = true;
            lowerPoint = DateTimeDeserializer.deserialize(start);
        }
        if (end.equals(POSITIVE_INFINITY)) {
            upperBound = false;
            upperPoint = null;
        } else {
            upperBound = true;
            upperPoint = DateTimeDeserializer.deserialize(end);
        }
        if (!lowerBound && !upperBound) {
            return Range.all();
        }
        if (!lowerBound) {
            if (upperClosed) {
                return Range.lessThan((Comparable)upperPoint);
            }
            return Range.atMost((Comparable)upperPoint);
        }
        if (!upperBound) {
            if (lowerClosed) {
                return Range.atLeast((Comparable)lowerPoint);
            }
            return Range.greaterThan((Comparable)lowerPoint);
        }
        if (lowerClosed) {
            if (upperClosed) {
                return Range.closed((Comparable)lowerPoint, (Comparable)upperPoint);
            }
            return Range.closedOpen((Comparable)lowerPoint, (Comparable)upperPoint);
        }
        if (upperClosed) {
            return Range.openClosed((Comparable)lowerPoint, (Comparable)upperPoint);
        }
        return Range.open((Comparable)lowerPoint, (Comparable)upperPoint);
    }
}

