/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jackson.modules;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.io.IOException;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateTimeRangeSerializer
extends StdSerializer<Range<DateTime>> {
    private static final String NEGATIVE_INFINITY = "-\u221e";
    private static final String POSITIVE_INFINITY = "+\u221e";
    private static DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZZ ZZZ");

    public DateTimeRangeSerializer() {
        super(Range.class, true);
    }

    public void serialize(Range<DateTime> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (value != null) {
            StringBuilder sb = new StringBuilder(64);
            if (value.hasLowerBound()) {
                if (value.lowerBoundType().equals((Object)BoundType.CLOSED)) {
                    sb.append('[');
                } else {
                    sb.append('(');
                }
                sb.append(formatter.print((ReadableInstant)value.lowerEndpoint()));
            } else {
                sb.append('(');
                sb.append(NEGATIVE_INFINITY);
            }
            sb.append(',');
            if (value.hasUpperBound()) {
                sb.append(formatter.print((ReadableInstant)value.upperEndpoint()));
                if (value.upperBoundType().equals((Object)BoundType.CLOSED)) {
                    sb.append(']');
                } else {
                    sb.append(')');
                }
            } else {
                sb.append(POSITIVE_INFINITY);
                sb.append(')');
            }
            gen.writeString(sb.toString());
        }
    }

    public void serializeWithType(Range<DateTime> value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        typeSer.writeTypePrefixForScalar(value, jgen, Range.class);
        this.serialize(value, jgen, provider);
        typeSer.writeTypeSuffixForScalar(value, jgen);
    }
}

