/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jackson.modules;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeSerializer
extends StdSerializer<DateTime> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateTimeSerializer.class);
    private static DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZZ ZZZ");

    public DateTimeSerializer() {
        super(DateTime.class, true);
    }

    public void serialize(DateTime value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeString(formatter.print((ReadableInstant)value));
    }

    public void serializeWithType(DateTime value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        typeSer.writeTypePrefixForScalar((Object)value, jgen, DateTime.class);
        this.serialize(value, jgen, provider);
        typeSer.writeTypeSuffixForScalar((Object)value, jgen);
    }
}

