/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jackson.modules;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeZoneDeserializer
extends JsonDeserializer<DateTimeZone> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateTimeZoneDeserializer.class);

    public DateTimeZone deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        DateTimeZone result;
        ObjectCodec oc = jsonParser.getCodec();
        JsonNode node = (JsonNode)oc.readTree(jsonParser);
        try {
            result = DateTimeZone.forID((String)node.textValue());
        }
        catch (IllegalArgumentException iae) {
            LOGGER.warn("Attempt to deserialize invalid datetimezone {}", (Object)node.textValue());
            throw new IOException("Invalid datetimezone value \"" + node.textValue() + "\"", iae);
        }
        return result;
    }
}

