/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jackson.modules;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntervalDeserializer
extends JsonDeserializer<Interval> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntervalDeserializer.class);
    private static DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZ");
    private static DateTimeZone utczone = DateTimeZone.forID((String)"UTC");

    public Interval deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ObjectCodec oc = jsonParser.getCodec();
        JsonNode node = (JsonNode)oc.readTree(jsonParser);
        DateTime start = this.deserializeDateTime(node, "start");
        DateTime end = this.deserializeDateTime(node, "end");
        return new Interval((ReadableInstant)start, (ReadableInstant)end);
    }

    private DateTime deserializeDateTime(JsonNode node, String prefix) throws IOException {
        JsonNode datetimenode = node.get(prefix + "datetime");
        if (datetimenode == null) {
            LOGGER.warn("Attempt to deserialize malformed interval");
            throw new IOException("Invalid interval value");
        }
        String datetime = datetimenode.textValue();
        JsonNode tznode = node.get(prefix + "timezone");
        String timezone = null;
        if (tznode != null) {
            timezone = tznode.textValue();
        }
        DateTime result = null;
        try {
            result = timezone == null || "UTC".equals(timezone) ? formatter.parseDateTime(datetime).withZone(utczone) : formatter.parseDateTime(datetime).withZone(DateTimeZone.forID((String)timezone));
        }
        catch (IllegalArgumentException iae) {
            LOGGER.warn("Attempt to deserialize invalid interval {},{}", (Object)datetime, (Object)timezone);
            throw new IOException("Invalid datetime value", iae);
        }
        return result;
    }
}

