/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jackson.modules;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDateDeserializer
extends JsonDeserializer<LocalDate> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalDateDeserializer.class);
    private static DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");

    public LocalDate deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ObjectCodec oc = jsonParser.getCodec();
        JsonNode node = (JsonNode)oc.readTree(jsonParser);
        LocalDate result = null;
        try {
            result = formatter.parseLocalDate(node.textValue());
        }
        catch (IllegalArgumentException iae) {
            LOGGER.warn("Attempt to deserialize invalid localdate {}", (Object)node.textValue());
            throw new IOException("Invalid localdate value \"" + node.textValue() + "\"", iae);
        }
        return result;
    }
}

