/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jackson.modules;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDateTimeDeserializer
extends JsonDeserializer<LocalDateTime> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalDateTimeDeserializer.class);
    private static DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss").withZone(DateTimeZone.UTC);

    public LocalDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ObjectCodec oc = jsonParser.getCodec();
        JsonNode node = (JsonNode)oc.readTree(jsonParser);
        try {
            return formatter.parseDateTime(node.textValue()).withZone(DateTimeZone.UTC).toLocalDateTime();
        }
        catch (IllegalArgumentException iae) {
            LOGGER.warn("Attempt to deserialize invalid localdatetime {}", (Object)node.textValue());
            throw new IOException("Invalid localdatetime value \"" + node.textValue() + "\"", iae);
        }
    }
}

