/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jackson.modules;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class LocalDateTimeSerializer
extends StdSerializer<LocalDateTime> {
    private static DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss").withZone(DateTimeZone.UTC);

    public LocalDateTimeSerializer() {
        super(LocalDateTime.class, true);
    }

    public void serialize(LocalDateTime value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeString(formatter.print((ReadableInstant)value.toDateTime().withZone(DateTimeZone.UTC)));
    }

    public void serializeWithType(LocalDateTime value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        typeSer.writeTypePrefixForScalar((Object)value, jgen, LocalDateTime.class);
        this.serialize(value, jgen, provider);
        typeSer.writeTypeSuffixForScalar((Object)value, jgen);
    }
}

